<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserInfoTx StructType
 * @subpackage Structs
 */
class UserInfoTx extends AbstractStructBase
{
    /**
     * The call
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $call;
    /**
     * The recv
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $recv;
    /**
     * The cdpn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cdpn;
    /**
     * The key
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $key;
    /**
     * The dsp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dsp;
    /**
     * Constructor method for UserInfoTx
     * @uses UserInfoTx::setCall()
     * @uses UserInfoTx::setRecv()
     * @uses UserInfoTx::setCdpn()
     * @uses UserInfoTx::setKey()
     * @uses UserInfoTx::setDsp()
     * @param int $call
     * @param bool $recv
     * @param string $cdpn
     * @param string $key
     * @param string $dsp
     */
    public function __construct($call = null, $recv = null, $cdpn = null, $key = null, $dsp = null)
    {
        $this
            ->setCall($call)
            ->setRecv($recv)
            ->setCdpn($cdpn)
            ->setKey($key)
            ->setDsp($dsp);
    }
    /**
     * Get call value
     * @return int
     */
    public function getCall()
    {
        return $this->call;
    }
    /**
     * Set call value
     * @param int $call
     * @return \StructType\UserInfoTx
     */
    public function setCall($call = null)
    {
        // validation for constraint: int
        if (!is_null($call) && !is_numeric($call)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($call)), __LINE__);
        }
        $this->call = $call;
        return $this;
    }
    /**
     * Get recv value
     * @return bool
     */
    public function getRecv()
    {
        return $this->recv;
    }
    /**
     * Set recv value
     * @param bool $recv
     * @return \StructType\UserInfoTx
     */
    public function setRecv($recv = null)
    {
        // validation for constraint: boolean
        if (!is_null($recv) && !is_bool($recv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($recv)), __LINE__);
        }
        $this->recv = $recv;
        return $this;
    }
    /**
     * Get cdpn value
     * @return string|null
     */
    public function getCdpn()
    {
        return $this->cdpn;
    }
    /**
     * Set cdpn value
     * @param string $cdpn
     * @return \StructType\UserInfoTx
     */
    public function setCdpn($cdpn = null)
    {
        // validation for constraint: string
        if (!is_null($cdpn) && !is_string($cdpn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cdpn)), __LINE__);
        }
        $this->cdpn = $cdpn;
        return $this;
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\UserInfoTx
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get dsp value
     * @return string|null
     */
    public function getDsp()
    {
        return $this->dsp;
    }
    /**
     * Set dsp value
     * @param string $dsp
     * @return \StructType\UserInfoTx
     */
    public function setDsp($dsp = null)
    {
        // validation for constraint: string
        if (!is_null($dsp) && !is_string($dsp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dsp)), __LINE__);
        }
        $this->dsp = $dsp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserInfoTx
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
