<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DevicesResponse StructType
 * @subpackage Structs
 */
class DevicesResponse extends AbstractStructBase
{
    /**
     * The Device
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Device[]
     */
    public $Device;
    /**
     * Constructor method for DevicesResponse
     * @uses DevicesResponse::setDevice()
     * @param \StructType\Device[] $device
     */
    public function __construct(array $device = array())
    {
        $this
            ->setDevice($device);
    }
    /**
     * Get Device value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Device[]|null
     */
    public function getDevice()
    {
        return isset($this->Device) ? $this->Device : null;
    }
    /**
     * Set Device value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Device[] $device
     * @return \StructType\DevicesResponse
     */
    public function setDevice(array $device = array())
    {
        foreach ($device as $devicesResponseDeviceItem) {
            // validation for constraint: itemType
            if (!$devicesResponseDeviceItem instanceof \StructType\Device) {
                throw new \InvalidArgumentException(sprintf('The Device property can only contain items of \StructType\Device, "%s" given', is_object($devicesResponseDeviceItem) ? get_class($devicesResponseDeviceItem) : gettype($devicesResponseDeviceItem)), __LINE__);
            }
        }
        if (is_null($device) || (is_array($device) && empty($device))) {
            unset($this->Device);
        } else {
            $this->Device = $device;
        }
        return $this;
    }
    /**
     * Add item to Device value
     * @throws \InvalidArgumentException
     * @param \StructType\Device $item
     * @return \StructType\DevicesResponse
     */
    public function addToDevice(\StructType\Device $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Device) {
            throw new \InvalidArgumentException(sprintf('The Device property can only contain items of \StructType\Device, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Device[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DevicesResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
