<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnyInfo StructType
 * @subpackage Structs
 */
class AnyInfo extends AbstractStructBase
{
    /**
     * The user
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UserInfo[]
     */
    public $user;
    /**
     * The call
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CallInfo[]
     */
    public $call;
    /**
     * The reg
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RegInfo[]
     */
    public $reg;
    /**
     * The info
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Info[]
     */
    public $info;
    /**
     * Constructor method for AnyInfo
     * @uses AnyInfo::setUser()
     * @uses AnyInfo::setCall()
     * @uses AnyInfo::setReg()
     * @uses AnyInfo::setInfo()
     * @param \StructType\UserInfo[] $user
     * @param \StructType\CallInfo[] $call
     * @param \StructType\RegInfo[] $reg
     * @param \StructType\Info[] $info
     */
    public function __construct(array $user = array(), array $call = array(), array $reg = array(), array $info = array())
    {
        $this
            ->setUser($user)
            ->setCall($call)
            ->setReg($reg)
            ->setInfo($info);
    }
    /**
     * Get user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UserInfo[]|null
     */
    public function getUser()
    {
        return isset($this->user) ? $this->user : null;
    }
    /**
     * Set user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UserInfo[] $user
     * @return \StructType\AnyInfo
     */
    public function setUser(array $user = array())
    {
        foreach ($user as $anyInfoUserItem) {
            // validation for constraint: itemType
            if (!$anyInfoUserItem instanceof \StructType\UserInfo) {
                throw new \InvalidArgumentException(sprintf('The user property can only contain items of \StructType\UserInfo, "%s" given', is_object($anyInfoUserItem) ? get_class($anyInfoUserItem) : gettype($anyInfoUserItem)), __LINE__);
            }
        }
        if (is_null($user) || (is_array($user) && empty($user))) {
            unset($this->user);
        } else {
            $this->user = $user;
        }
        return $this;
    }
    /**
     * Add item to user value
     * @throws \InvalidArgumentException
     * @param \StructType\UserInfo $item
     * @return \StructType\AnyInfo
     */
    public function addToUser(\StructType\UserInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UserInfo) {
            throw new \InvalidArgumentException(sprintf('The user property can only contain items of \StructType\UserInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->user[] = $item;
        return $this;
    }
    /**
     * Get call value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CallInfo[]|null
     */
    public function getCall()
    {
        return isset($this->call) ? $this->call : null;
    }
    /**
     * Set call value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CallInfo[] $call
     * @return \StructType\AnyInfo
     */
    public function setCall(array $call = array())
    {
        foreach ($call as $anyInfoCallItem) {
            // validation for constraint: itemType
            if (!$anyInfoCallItem instanceof \StructType\CallInfo) {
                throw new \InvalidArgumentException(sprintf('The call property can only contain items of \StructType\CallInfo, "%s" given', is_object($anyInfoCallItem) ? get_class($anyInfoCallItem) : gettype($anyInfoCallItem)), __LINE__);
            }
        }
        if (is_null($call) || (is_array($call) && empty($call))) {
            unset($this->call);
        } else {
            $this->call = $call;
        }
        return $this;
    }
    /**
     * Add item to call value
     * @throws \InvalidArgumentException
     * @param \StructType\CallInfo $item
     * @return \StructType\AnyInfo
     */
    public function addToCall(\StructType\CallInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CallInfo) {
            throw new \InvalidArgumentException(sprintf('The call property can only contain items of \StructType\CallInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->call[] = $item;
        return $this;
    }
    /**
     * Get reg value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RegInfo[]|null
     */
    public function getReg()
    {
        return isset($this->reg) ? $this->reg : null;
    }
    /**
     * Set reg value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RegInfo[] $reg
     * @return \StructType\AnyInfo
     */
    public function setReg(array $reg = array())
    {
        foreach ($reg as $anyInfoRegItem) {
            // validation for constraint: itemType
            if (!$anyInfoRegItem instanceof \StructType\RegInfo) {
                throw new \InvalidArgumentException(sprintf('The reg property can only contain items of \StructType\RegInfo, "%s" given', is_object($anyInfoRegItem) ? get_class($anyInfoRegItem) : gettype($anyInfoRegItem)), __LINE__);
            }
        }
        if (is_null($reg) || (is_array($reg) && empty($reg))) {
            unset($this->reg);
        } else {
            $this->reg = $reg;
        }
        return $this;
    }
    /**
     * Add item to reg value
     * @throws \InvalidArgumentException
     * @param \StructType\RegInfo $item
     * @return \StructType\AnyInfo
     */
    public function addToReg(\StructType\RegInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RegInfo) {
            throw new \InvalidArgumentException(sprintf('The reg property can only contain items of \StructType\RegInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->reg[] = $item;
        return $this;
    }
    /**
     * Get info value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Info[]|null
     */
    public function getInfo()
    {
        return isset($this->info) ? $this->info : null;
    }
    /**
     * Set info value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Info[] $info
     * @return \StructType\AnyInfo
     */
    public function setInfo(array $info = array())
    {
        foreach ($info as $anyInfoInfoItem) {
            // validation for constraint: itemType
            if (!$anyInfoInfoItem instanceof \StructType\Info) {
                throw new \InvalidArgumentException(sprintf('The info property can only contain items of \StructType\Info, "%s" given', is_object($anyInfoInfoItem) ? get_class($anyInfoInfoItem) : gettype($anyInfoInfoItem)), __LINE__);
            }
        }
        if (is_null($info) || (is_array($info) && empty($info))) {
            unset($this->info);
        } else {
            $this->info = $info;
        }
        return $this;
    }
    /**
     * Add item to info value
     * @throws \InvalidArgumentException
     * @param \StructType\Info $item
     * @return \StructType\AnyInfo
     */
    public function addToInfo(\StructType\Info $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Info) {
            throw new \InvalidArgumentException(sprintf('The info property can only contain items of \StructType\Info, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->info[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AnyInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
