<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnyInfo StructType
 * @subpackage Structs
 */
class AnyInfo extends AbstractStructBase
{
    /**
     * The user
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1 | unbounded
     * - minOccurs: 0 | 0
     * - arrayType: inno:UserInfo[]
     * - ref: SOAP-ENC:arrayType
     * - type: inno:UserInfo
     * @var \StructType\UserInfo[]
     */
    public $user;
    /**
     * The call
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1 | unbounded
     * - minOccurs: 0 | 0
     * - arrayType: inno:CallInfo[]
     * - ref: SOAP-ENC:arrayType
     * - type: inno:CallInfo
     * @var \StructType\CallInfo[]
     */
    public $call;
    /**
     * The reg
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1 | unbounded
     * - minOccurs: 0 | 0
     * - arrayType: inno:RegInfo[]
     * - ref: SOAP-ENC:arrayType
     * - type: inno:RegInfo
     * @var \StructType\RegInfo[]
     */
    public $reg;
    /**
     * The info
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1 | unbounded
     * - minOccurs: 0 | 0
     * - arrayType: inno:Info[]
     * - ref: SOAP-ENC:arrayType
     * - type: inno:Info
     * @var \StructType\Info[]
     */
    public $info;
    /**
     * Constructor method for AnyInfo
     * @uses AnyInfo::setUser()
     * @uses AnyInfo::setCall()
     * @uses AnyInfo::setReg()
     * @uses AnyInfo::setInfo()
     * @param \StructType\UserInfo[] $user
     * @param \StructType\CallInfo[] $call
     * @param \StructType\RegInfo[] $reg
     * @param \StructType\Info[] $info
     */
    public function __construct(array $user = array(), array $call = array(), array $reg = array(), array $info = array())
    {
        $this
            ->setUser($user)
            ->setCall($call)
            ->setReg($reg)
            ->setInfo($info);
    }
    /**
     * Get user value
     * @return \StructType\UserInfo[]
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @throws \InvalidArgumentException
     * @param \StructType\UserInfo[] $user
     * @return \StructType\AnyInfo
     */
    public function setUser(array $user = array())
    {
        foreach ($user as $anyInfoUserItem) {
            // validation for constraint: itemType
            if (!$anyInfoUserItem instanceof \StructType\UserInfo) {
                throw new \InvalidArgumentException(sprintf('The user property can only contain items of \StructType\UserInfo, "%s" given', is_object($anyInfoUserItem) ? get_class($anyInfoUserItem) : gettype($anyInfoUserItem)), __LINE__);
            }
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Add item to user value
     * @throws \InvalidArgumentException
     * @param \StructType\UserInfo $item
     * @return \StructType\AnyInfo
     */
    public function addToUser(\StructType\UserInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UserInfo) {
            throw new \InvalidArgumentException(sprintf('The user property can only contain items of \StructType\UserInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->user[] = $item;
        return $this;
    }
    /**
     * Get call value
     * @return \StructType\CallInfo[]
     */
    public function getCall()
    {
        return $this->call;
    }
    /**
     * Set call value
     * @throws \InvalidArgumentException
     * @param \StructType\CallInfo[] $call
     * @return \StructType\AnyInfo
     */
    public function setCall(array $call = array())
    {
        foreach ($call as $anyInfoCallItem) {
            // validation for constraint: itemType
            if (!$anyInfoCallItem instanceof \StructType\CallInfo) {
                throw new \InvalidArgumentException(sprintf('The call property can only contain items of \StructType\CallInfo, "%s" given', is_object($anyInfoCallItem) ? get_class($anyInfoCallItem) : gettype($anyInfoCallItem)), __LINE__);
            }
        }
        $this->call = $call;
        return $this;
    }
    /**
     * Add item to call value
     * @throws \InvalidArgumentException
     * @param \StructType\CallInfo $item
     * @return \StructType\AnyInfo
     */
    public function addToCall(\StructType\CallInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CallInfo) {
            throw new \InvalidArgumentException(sprintf('The call property can only contain items of \StructType\CallInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->call[] = $item;
        return $this;
    }
    /**
     * Get reg value
     * @return \StructType\RegInfo[]
     */
    public function getReg()
    {
        return $this->reg;
    }
    /**
     * Set reg value
     * @throws \InvalidArgumentException
     * @param \StructType\RegInfo[] $reg
     * @return \StructType\AnyInfo
     */
    public function setReg(array $reg = array())
    {
        foreach ($reg as $anyInfoRegItem) {
            // validation for constraint: itemType
            if (!$anyInfoRegItem instanceof \StructType\RegInfo) {
                throw new \InvalidArgumentException(sprintf('The reg property can only contain items of \StructType\RegInfo, "%s" given', is_object($anyInfoRegItem) ? get_class($anyInfoRegItem) : gettype($anyInfoRegItem)), __LINE__);
            }
        }
        $this->reg = $reg;
        return $this;
    }
    /**
     * Add item to reg value
     * @throws \InvalidArgumentException
     * @param \StructType\RegInfo $item
     * @return \StructType\AnyInfo
     */
    public function addToReg(\StructType\RegInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RegInfo) {
            throw new \InvalidArgumentException(sprintf('The reg property can only contain items of \StructType\RegInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->reg[] = $item;
        return $this;
    }
    /**
     * Get info value
     * @return \StructType\Info[]
     */
    public function getInfo()
    {
        return $this->info;
    }
    /**
     * Set info value
     * @throws \InvalidArgumentException
     * @param \StructType\Info[] $info
     * @return \StructType\AnyInfo
     */
    public function setInfo(array $info = array())
    {
        foreach ($info as $anyInfoInfoItem) {
            // validation for constraint: itemType
            if (!$anyInfoInfoItem instanceof \StructType\Info) {
                throw new \InvalidArgumentException(sprintf('The info property can only contain items of \StructType\Info, "%s" given', is_object($anyInfoInfoItem) ? get_class($anyInfoInfoItem) : gettype($anyInfoInfoItem)), __LINE__);
            }
        }
        $this->info = $info;
        return $this;
    }
    /**
     * Add item to info value
     * @throws \InvalidArgumentException
     * @param \StructType\Info $item
     * @return \StructType\AnyInfo
     */
    public function addToInfo(\StructType\Info $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Info) {
            throw new \InvalidArgumentException(sprintf('The info property can only contain items of \StructType\Info, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->info[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AnyInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
