<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CallInfo StructType
 * @subpackage Structs
 */
class CallInfo extends AbstractStructBase
{
    /**
     * The user
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $user;
    /**
     * The call
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $call;
    /**
     * The reg
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $reg;
    /**
     * The active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $active;
    /**
     * The state
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $state;
    /**
     * The No
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1 | unbounded
     * - minOccurs: 1 | 0
     * - arrayType: inno:No[]
     * - ref: SOAP-ENC:arrayType
     * - type: inno:No
     * @var \StructType\No[]
     */
    public $No;
    /**
     * The msg
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $msg;
    /**
     * The info
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1 | unbounded
     * - minOccurs: 1 | 0
     * - arrayType: inno:Info[]
     * - ref: SOAP-ENC:arrayType
     * - type: inno:Info
     * @var \StructType\Info[]
     */
    public $info;
    /**
     * Constructor method for CallInfo
     * @uses CallInfo::setUser()
     * @uses CallInfo::setCall()
     * @uses CallInfo::setReg()
     * @uses CallInfo::setActive()
     * @uses CallInfo::setState()
     * @uses CallInfo::setNo()
     * @uses CallInfo::setMsg()
     * @uses CallInfo::setInfo()
     * @param int $user
     * @param int $call
     * @param int $reg
     * @param bool $active
     * @param int $state
     * @param \StructType\No[] $no
     * @param string $msg
     * @param \StructType\Info[] $info
     */
    public function __construct($user = null, $call = null, $reg = null, $active = null, $state = null, array $no = array(), $msg = null, array $info = array())
    {
        $this
            ->setUser($user)
            ->setCall($call)
            ->setReg($reg)
            ->setActive($active)
            ->setState($state)
            ->setNo($no)
            ->setMsg($msg)
            ->setInfo($info);
    }
    /**
     * Get user value
     * @return int
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param int $user
     * @return \StructType\CallInfo
     */
    public function setUser($user = null)
    {
        // validation for constraint: int
        if (!is_null($user) && !is_numeric($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Get call value
     * @return int
     */
    public function getCall()
    {
        return $this->call;
    }
    /**
     * Set call value
     * @param int $call
     * @return \StructType\CallInfo
     */
    public function setCall($call = null)
    {
        // validation for constraint: int
        if (!is_null($call) && !is_numeric($call)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($call)), __LINE__);
        }
        $this->call = $call;
        return $this;
    }
    /**
     * Get reg value
     * @return int
     */
    public function getReg()
    {
        return $this->reg;
    }
    /**
     * Set reg value
     * @param int $reg
     * @return \StructType\CallInfo
     */
    public function setReg($reg = null)
    {
        // validation for constraint: int
        if (!is_null($reg) && !is_numeric($reg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reg)), __LINE__);
        }
        $this->reg = $reg;
        return $this;
    }
    /**
     * Get active value
     * @return bool
     */
    public function getActive()
    {
        return $this->active;
    }
    /**
     * Set active value
     * @param bool $active
     * @return \StructType\CallInfo
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->active = $active;
        return $this;
    }
    /**
     * Get state value
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param int $state
     * @return \StructType\CallInfo
     */
    public function setState($state = null)
    {
        // validation for constraint: int
        if (!is_null($state) && !is_numeric($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get No value
     * @return \StructType\No[]
     */
    public function getNo()
    {
        return $this->No;
    }
    /**
     * Set No value
     * @throws \InvalidArgumentException
     * @param \StructType\No[] $no
     * @return \StructType\CallInfo
     */
    public function setNo(array $no = array())
    {
        foreach ($no as $callInfoNoItem) {
            // validation for constraint: itemType
            if (!$callInfoNoItem instanceof \StructType\No) {
                throw new \InvalidArgumentException(sprintf('The No property can only contain items of \StructType\No, "%s" given', is_object($callInfoNoItem) ? get_class($callInfoNoItem) : gettype($callInfoNoItem)), __LINE__);
            }
        }
        $this->No = $no;
        return $this;
    }
    /**
     * Add item to No value
     * @throws \InvalidArgumentException
     * @param \StructType\No $item
     * @return \StructType\CallInfo
     */
    public function addToNo(\StructType\No $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\No) {
            throw new \InvalidArgumentException(sprintf('The No property can only contain items of \StructType\No, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->No[] = $item;
        return $this;
    }
    /**
     * Get msg value
     * @return string
     */
    public function getMsg()
    {
        return $this->msg;
    }
    /**
     * Set msg value
     * @param string $msg
     * @return \StructType\CallInfo
     */
    public function setMsg($msg = null)
    {
        // validation for constraint: string
        if (!is_null($msg) && !is_string($msg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($msg)), __LINE__);
        }
        $this->msg = $msg;
        return $this;
    }
    /**
     * Get info value
     * @return \StructType\Info[]
     */
    public function getInfo()
    {
        return $this->info;
    }
    /**
     * Set info value
     * @throws \InvalidArgumentException
     * @param \StructType\Info[] $info
     * @return \StructType\CallInfo
     */
    public function setInfo(array $info = array())
    {
        foreach ($info as $callInfoInfoItem) {
            // validation for constraint: itemType
            if (!$callInfoInfoItem instanceof \StructType\Info) {
                throw new \InvalidArgumentException(sprintf('The info property can only contain items of \StructType\Info, "%s" given', is_object($callInfoInfoItem) ? get_class($callInfoInfoItem) : gettype($callInfoInfoItem)), __LINE__);
            }
        }
        $this->info = $info;
        return $this;
    }
    /**
     * Add item to info value
     * @throws \InvalidArgumentException
     * @param \StructType\Info $item
     * @return \StructType\CallInfo
     */
    public function addToInfo(\StructType\Info $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Info) {
            throw new \InvalidArgumentException(sprintf('The info property can only contain items of \StructType\Info, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->info[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CallInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
