<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Docdata\ClassMap::get(),
);
/**
 * Samples for Create ServiceType
 */
$create = new \Docdata\ServiceType\Create($options);
/**
 * Sample call for create operation/method
 */
if ($create->create(new \Docdata\StructType\CreateRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Refund ServiceType
 */
$refund = new \Docdata\ServiceType\Refund($options);
/**
 * Sample call for refund operation/method
 */
if ($refund->refund(new \Docdata\StructType\RefundRequest()) !== false) {
    print_r($refund->getResult());
} else {
    print_r($refund->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \Docdata\ServiceType\Cancel($options);
/**
 * Sample call for cancel operation/method
 */
if ($cancel->cancel(new \Docdata\StructType\CancelRequest()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Start ServiceType
 */
$start = new \Docdata\ServiceType\Start($options);
/**
 * Sample call for start operation/method
 */
if ($start->start(new \Docdata\StructType\StartRequest()) !== false) {
    print_r($start->getResult());
} else {
    print_r($start->getLastError());
}
/**
 * Samples for Proceed ServiceType
 */
$proceed = new \Docdata\ServiceType\Proceed($options);
/**
 * Sample call for proceed operation/method
 */
if ($proceed->proceed(new \Docdata\StructType\ProceedRequest()) !== false) {
    print_r($proceed->getResult());
} else {
    print_r($proceed->getLastError());
}
/**
 * Samples for Capture ServiceType
 */
$capture = new \Docdata\ServiceType\Capture($options);
/**
 * Sample call for capture operation/method
 */
if ($capture->capture(new \Docdata\StructType\CaptureRequest()) !== false) {
    print_r($capture->getResult());
} else {
    print_r($capture->getLastError());
}
/**
 * Samples for Status ServiceType
 */
$status = new \Docdata\ServiceType\Status($options);
/**
 * Sample call for status operation/method
 */
if ($status->status(new \Docdata\StructType\StatusRequest()) !== false) {
    print_r($status->getResult());
} else {
    print_r($status->getLastError());
}
/**
 * Sample call for statusExtended operation/method
 */
if ($status->statusExtended(new \Docdata\StructType\ExtendedStatusRequest()) !== false) {
    print_r($status->getResult());
} else {
    print_r($status->getLastError());
}
/**
 * Samples for List ServiceType
 */
$list = new \Docdata\ServiceType\_List($options);
/**
 * Sample call for listPaymentMethods operation/method
 */
if ($list->listPaymentMethods(new \Docdata\StructType\ListPaymentMethodsRequest()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
