<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for token StructType
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class Token extends AbstractStructBase
{
    /**
     * The amexTokenInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\CardTokenInput
     */
    public $amexTokenInput;
    /**
     * The masterCardTokenInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\CardTokenInput
     */
    public $masterCardTokenInput;
    /**
     * The visaTokenInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\CardTokenInput
     */
    public $visaTokenInput;
    /**
     * The key
     * Meta informations extracted from the WSDL
     * - documentation: Key of the token
     * - use: required
     * - maxLength: 512
     * - minLength: 1
     * @var string
     */
    public $key;
    /**
     * Constructor method for token
     * @uses Token::setAmexTokenInput()
     * @uses Token::setMasterCardTokenInput()
     * @uses Token::setVisaTokenInput()
     * @uses Token::setKey()
     * @param \Docdata\StructType\CardTokenInput $amexTokenInput
     * @param \Docdata\StructType\CardTokenInput $masterCardTokenInput
     * @param \Docdata\StructType\CardTokenInput $visaTokenInput
     * @param string $key
     */
    public function __construct(\Docdata\StructType\CardTokenInput $amexTokenInput = null, \Docdata\StructType\CardTokenInput $masterCardTokenInput = null, \Docdata\StructType\CardTokenInput $visaTokenInput = null, $key = null)
    {
        $this
            ->setAmexTokenInput($amexTokenInput)
            ->setMasterCardTokenInput($masterCardTokenInput)
            ->setVisaTokenInput($visaTokenInput)
            ->setKey($key);
    }
    /**
     * Get amexTokenInput value
     * @return \Docdata\StructType\CardTokenInput
     */
    public function getAmexTokenInput()
    {
        return $this->amexTokenInput;
    }
    /**
     * Set amexTokenInput value
     * @param \Docdata\StructType\CardTokenInput $amexTokenInput
     * @return \Docdata\StructType\Token
     */
    public function setAmexTokenInput(\Docdata\StructType\CardTokenInput $amexTokenInput = null)
    {
        $this->amexTokenInput = $amexTokenInput;
        return $this;
    }
    /**
     * Get masterCardTokenInput value
     * @return \Docdata\StructType\CardTokenInput
     */
    public function getMasterCardTokenInput()
    {
        return $this->masterCardTokenInput;
    }
    /**
     * Set masterCardTokenInput value
     * @param \Docdata\StructType\CardTokenInput $masterCardTokenInput
     * @return \Docdata\StructType\Token
     */
    public function setMasterCardTokenInput(\Docdata\StructType\CardTokenInput $masterCardTokenInput = null)
    {
        $this->masterCardTokenInput = $masterCardTokenInput;
        return $this;
    }
    /**
     * Get visaTokenInput value
     * @return \Docdata\StructType\CardTokenInput
     */
    public function getVisaTokenInput()
    {
        return $this->visaTokenInput;
    }
    /**
     * Set visaTokenInput value
     * @param \Docdata\StructType\CardTokenInput $visaTokenInput
     * @return \Docdata\StructType\Token
     */
    public function setVisaTokenInput(\Docdata\StructType\CardTokenInput $visaTokenInput = null)
    {
        $this->visaTokenInput = $visaTokenInput;
        return $this;
    }
    /**
     * Get key value
     * @return string
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \Docdata\StructType\Token
     */
    public function setKey($key = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($key) && strlen($key) > 512) || (is_array($key) && count($key) > 512)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 512 element(s) or a scalar of 512 character(s) at most, "%d" length given', is_scalar($key) ? strlen($key) : count($key)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($key) && strlen($key) < 1) || (is_array($key) && count($key) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\Token
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
