<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for refundResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: Response to a refund request.
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class RefundResponse extends AbstractStructBase
{
    /**
     * The refundErrors
     * Meta informations extracted from the WSDL
     * - documentation: An error occurred. No refund request was created.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\RefundErrors
     */
    public $refundErrors;
    /**
     * The refundSuccess
     * Meta informations extracted from the WSDL
     * - documentation: A request for refund was successfully accepted. This does not mean that the whole request will be or has been processed successfully!
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\RefundSuccess
     */
    public $refundSuccess;
    /**
     * The ddpXsdVersion
     * Meta informations extracted from the WSDL
     * - use: required
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $ddpXsdVersion;
    /**
     * Constructor method for refundResponse
     * @uses RefundResponse::setRefundErrors()
     * @uses RefundResponse::setRefundSuccess()
     * @uses RefundResponse::setDdpXsdVersion()
     * @param \Docdata\StructType\RefundErrors $refundErrors
     * @param \Docdata\StructType\RefundSuccess $refundSuccess
     * @param string $ddpXsdVersion
     */
    public function __construct(\Docdata\StructType\RefundErrors $refundErrors = null, \Docdata\StructType\RefundSuccess $refundSuccess = null, $ddpXsdVersion = null)
    {
        $this
            ->setRefundErrors($refundErrors)
            ->setRefundSuccess($refundSuccess)
            ->setDdpXsdVersion($ddpXsdVersion);
    }
    /**
     * Get refundErrors value
     * @return \Docdata\StructType\RefundErrors
     */
    public function getRefundErrors()
    {
        return $this->refundErrors;
    }
    /**
     * Set refundErrors value
     * @param \Docdata\StructType\RefundErrors $refundErrors
     * @return \Docdata\StructType\RefundResponse
     */
    public function setRefundErrors(\Docdata\StructType\RefundErrors $refundErrors = null)
    {
        $this->refundErrors = $refundErrors;
        return $this;
    }
    /**
     * Get refundSuccess value
     * @return \Docdata\StructType\RefundSuccess
     */
    public function getRefundSuccess()
    {
        return $this->refundSuccess;
    }
    /**
     * Set refundSuccess value
     * @param \Docdata\StructType\RefundSuccess $refundSuccess
     * @return \Docdata\StructType\RefundResponse
     */
    public function setRefundSuccess(\Docdata\StructType\RefundSuccess $refundSuccess = null)
    {
        $this->refundSuccess = $refundSuccess;
        return $this;
    }
    /**
     * Get ddpXsdVersion value
     * @return string
     */
    public function getDdpXsdVersion()
    {
        return $this->ddpXsdVersion;
    }
    /**
     * Set ddpXsdVersion value
     * @param string $ddpXsdVersion
     * @return \Docdata\StructType\RefundResponse
     */
    public function setDdpXsdVersion($ddpXsdVersion = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ddpXsdVersion) && strlen($ddpXsdVersion) > 35) || (is_array($ddpXsdVersion) && count($ddpXsdVersion) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($ddpXsdVersion) ? strlen($ddpXsdVersion) : count($ddpXsdVersion)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($ddpXsdVersion) && strlen($ddpXsdVersion) < 1) || (is_array($ddpXsdVersion) && count($ddpXsdVersion) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ddpXsdVersion) && !is_string($ddpXsdVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ddpXsdVersion)), __LINE__);
        }
        $this->ddpXsdVersion = $ddpXsdVersion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\RefundResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
