<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paymentRequestInput StructType
 * Meta informations extracted from the WSDL
 * - documentation: Payment information to start a payment.
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class PaymentRequestInput extends AbstractStructBase
{
    /**
     * The paymentMethod
     * Meta informations extracted from the WSDL
     * - documentation: Payment method to be used.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $paymentMethod;
    /**
     * The amexPaymentInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\CardPaymentInput
     */
    public $amexPaymentInput;
    /**
     * The masterCardPaymentInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\CardPaymentInput
     */
    public $masterCardPaymentInput;
    /**
     * The misterCashPaymentInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\CardPaymentInput
     */
    public $misterCashPaymentInput;
    /**
     * The maestroPaymentInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\CardPaymentInput
     */
    public $maestroPaymentInput;
    /**
     * The visaPaymentInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\CardPaymentInput
     */
    public $visaPaymentInput;
    /**
     * The directDebitPaymentInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\DirectDebitPaymentInput
     */
    public $directDebitPaymentInput;
    /**
     * The bankTransferPaymentInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\BankTransferPaymentInput
     */
    public $bankTransferPaymentInput;
    /**
     * The pointOfSalePaymentInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\PointOfSalePaymentInput
     */
    public $pointOfSalePaymentInput;
    /**
     * The offlinePaymentInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\OfflinePaymentInput
     */
    public $offlinePaymentInput;
    /**
     * The elvPaymentInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\ElvPaymentInput
     */
    public $elvPaymentInput;
    /**
     * The iDealPaymentInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\IDealPaymentInput
     */
    public $iDealPaymentInput;
    /**
     * Constructor method for paymentRequestInput
     * @uses PaymentRequestInput::setPaymentMethod()
     * @uses PaymentRequestInput::setAmexPaymentInput()
     * @uses PaymentRequestInput::setMasterCardPaymentInput()
     * @uses PaymentRequestInput::setMisterCashPaymentInput()
     * @uses PaymentRequestInput::setMaestroPaymentInput()
     * @uses PaymentRequestInput::setVisaPaymentInput()
     * @uses PaymentRequestInput::setDirectDebitPaymentInput()
     * @uses PaymentRequestInput::setBankTransferPaymentInput()
     * @uses PaymentRequestInput::setPointOfSalePaymentInput()
     * @uses PaymentRequestInput::setOfflinePaymentInput()
     * @uses PaymentRequestInput::setElvPaymentInput()
     * @uses PaymentRequestInput::setIDealPaymentInput()
     * @param string $paymentMethod
     * @param \Docdata\StructType\CardPaymentInput $amexPaymentInput
     * @param \Docdata\StructType\CardPaymentInput $masterCardPaymentInput
     * @param \Docdata\StructType\CardPaymentInput $misterCashPaymentInput
     * @param \Docdata\StructType\CardPaymentInput $maestroPaymentInput
     * @param \Docdata\StructType\CardPaymentInput $visaPaymentInput
     * @param \Docdata\StructType\DirectDebitPaymentInput $directDebitPaymentInput
     * @param \Docdata\StructType\BankTransferPaymentInput $bankTransferPaymentInput
     * @param \Docdata\StructType\PointOfSalePaymentInput $pointOfSalePaymentInput
     * @param \Docdata\StructType\OfflinePaymentInput $offlinePaymentInput
     * @param \Docdata\StructType\ElvPaymentInput $elvPaymentInput
     * @param \Docdata\StructType\IDealPaymentInput $iDealPaymentInput
     */
    public function __construct($paymentMethod = null, \Docdata\StructType\CardPaymentInput $amexPaymentInput = null, \Docdata\StructType\CardPaymentInput $masterCardPaymentInput = null, \Docdata\StructType\CardPaymentInput $misterCashPaymentInput = null, \Docdata\StructType\CardPaymentInput $maestroPaymentInput = null, \Docdata\StructType\CardPaymentInput $visaPaymentInput = null, \Docdata\StructType\DirectDebitPaymentInput $directDebitPaymentInput = null, \Docdata\StructType\BankTransferPaymentInput $bankTransferPaymentInput = null, \Docdata\StructType\PointOfSalePaymentInput $pointOfSalePaymentInput = null, \Docdata\StructType\OfflinePaymentInput $offlinePaymentInput = null, \Docdata\StructType\ElvPaymentInput $elvPaymentInput = null, \Docdata\StructType\IDealPaymentInput $iDealPaymentInput = null)
    {
        $this
            ->setPaymentMethod($paymentMethod)
            ->setAmexPaymentInput($amexPaymentInput)
            ->setMasterCardPaymentInput($masterCardPaymentInput)
            ->setMisterCashPaymentInput($misterCashPaymentInput)
            ->setMaestroPaymentInput($maestroPaymentInput)
            ->setVisaPaymentInput($visaPaymentInput)
            ->setDirectDebitPaymentInput($directDebitPaymentInput)
            ->setBankTransferPaymentInput($bankTransferPaymentInput)
            ->setPointOfSalePaymentInput($pointOfSalePaymentInput)
            ->setOfflinePaymentInput($offlinePaymentInput)
            ->setElvPaymentInput($elvPaymentInput)
            ->setIDealPaymentInput($iDealPaymentInput);
    }
    /**
     * Get paymentMethod value
     * @return string
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }
    /**
     * Set paymentMethod value
     * @param string $paymentMethod
     * @return \Docdata\StructType\PaymentRequestInput
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($paymentMethod) && strlen($paymentMethod) > 50) || (is_array($paymentMethod) && count($paymentMethod) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($paymentMethod) ? strlen($paymentMethod) : count($paymentMethod)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($paymentMethod) && strlen($paymentMethod) < 1) || (is_array($paymentMethod) && count($paymentMethod) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentMethod)), __LINE__);
        }
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get amexPaymentInput value
     * @return \Docdata\StructType\CardPaymentInput
     */
    public function getAmexPaymentInput()
    {
        return $this->amexPaymentInput;
    }
    /**
     * Set amexPaymentInput value
     * @param \Docdata\StructType\CardPaymentInput $amexPaymentInput
     * @return \Docdata\StructType\PaymentRequestInput
     */
    public function setAmexPaymentInput(\Docdata\StructType\CardPaymentInput $amexPaymentInput = null)
    {
        $this->amexPaymentInput = $amexPaymentInput;
        return $this;
    }
    /**
     * Get masterCardPaymentInput value
     * @return \Docdata\StructType\CardPaymentInput
     */
    public function getMasterCardPaymentInput()
    {
        return $this->masterCardPaymentInput;
    }
    /**
     * Set masterCardPaymentInput value
     * @param \Docdata\StructType\CardPaymentInput $masterCardPaymentInput
     * @return \Docdata\StructType\PaymentRequestInput
     */
    public function setMasterCardPaymentInput(\Docdata\StructType\CardPaymentInput $masterCardPaymentInput = null)
    {
        $this->masterCardPaymentInput = $masterCardPaymentInput;
        return $this;
    }
    /**
     * Get misterCashPaymentInput value
     * @return \Docdata\StructType\CardPaymentInput
     */
    public function getMisterCashPaymentInput()
    {
        return $this->misterCashPaymentInput;
    }
    /**
     * Set misterCashPaymentInput value
     * @param \Docdata\StructType\CardPaymentInput $misterCashPaymentInput
     * @return \Docdata\StructType\PaymentRequestInput
     */
    public function setMisterCashPaymentInput(\Docdata\StructType\CardPaymentInput $misterCashPaymentInput = null)
    {
        $this->misterCashPaymentInput = $misterCashPaymentInput;
        return $this;
    }
    /**
     * Get maestroPaymentInput value
     * @return \Docdata\StructType\CardPaymentInput
     */
    public function getMaestroPaymentInput()
    {
        return $this->maestroPaymentInput;
    }
    /**
     * Set maestroPaymentInput value
     * @param \Docdata\StructType\CardPaymentInput $maestroPaymentInput
     * @return \Docdata\StructType\PaymentRequestInput
     */
    public function setMaestroPaymentInput(\Docdata\StructType\CardPaymentInput $maestroPaymentInput = null)
    {
        $this->maestroPaymentInput = $maestroPaymentInput;
        return $this;
    }
    /**
     * Get visaPaymentInput value
     * @return \Docdata\StructType\CardPaymentInput
     */
    public function getVisaPaymentInput()
    {
        return $this->visaPaymentInput;
    }
    /**
     * Set visaPaymentInput value
     * @param \Docdata\StructType\CardPaymentInput $visaPaymentInput
     * @return \Docdata\StructType\PaymentRequestInput
     */
    public function setVisaPaymentInput(\Docdata\StructType\CardPaymentInput $visaPaymentInput = null)
    {
        $this->visaPaymentInput = $visaPaymentInput;
        return $this;
    }
    /**
     * Get directDebitPaymentInput value
     * @return \Docdata\StructType\DirectDebitPaymentInput
     */
    public function getDirectDebitPaymentInput()
    {
        return $this->directDebitPaymentInput;
    }
    /**
     * Set directDebitPaymentInput value
     * @param \Docdata\StructType\DirectDebitPaymentInput $directDebitPaymentInput
     * @return \Docdata\StructType\PaymentRequestInput
     */
    public function setDirectDebitPaymentInput(\Docdata\StructType\DirectDebitPaymentInput $directDebitPaymentInput = null)
    {
        $this->directDebitPaymentInput = $directDebitPaymentInput;
        return $this;
    }
    /**
     * Get bankTransferPaymentInput value
     * @return \Docdata\StructType\BankTransferPaymentInput
     */
    public function getBankTransferPaymentInput()
    {
        return $this->bankTransferPaymentInput;
    }
    /**
     * Set bankTransferPaymentInput value
     * @param \Docdata\StructType\BankTransferPaymentInput $bankTransferPaymentInput
     * @return \Docdata\StructType\PaymentRequestInput
     */
    public function setBankTransferPaymentInput(\Docdata\StructType\BankTransferPaymentInput $bankTransferPaymentInput = null)
    {
        $this->bankTransferPaymentInput = $bankTransferPaymentInput;
        return $this;
    }
    /**
     * Get pointOfSalePaymentInput value
     * @return \Docdata\StructType\PointOfSalePaymentInput
     */
    public function getPointOfSalePaymentInput()
    {
        return $this->pointOfSalePaymentInput;
    }
    /**
     * Set pointOfSalePaymentInput value
     * @param \Docdata\StructType\PointOfSalePaymentInput $pointOfSalePaymentInput
     * @return \Docdata\StructType\PaymentRequestInput
     */
    public function setPointOfSalePaymentInput(\Docdata\StructType\PointOfSalePaymentInput $pointOfSalePaymentInput = null)
    {
        $this->pointOfSalePaymentInput = $pointOfSalePaymentInput;
        return $this;
    }
    /**
     * Get offlinePaymentInput value
     * @return \Docdata\StructType\OfflinePaymentInput
     */
    public function getOfflinePaymentInput()
    {
        return $this->offlinePaymentInput;
    }
    /**
     * Set offlinePaymentInput value
     * @param \Docdata\StructType\OfflinePaymentInput $offlinePaymentInput
     * @return \Docdata\StructType\PaymentRequestInput
     */
    public function setOfflinePaymentInput(\Docdata\StructType\OfflinePaymentInput $offlinePaymentInput = null)
    {
        $this->offlinePaymentInput = $offlinePaymentInput;
        return $this;
    }
    /**
     * Get elvPaymentInput value
     * @return \Docdata\StructType\ElvPaymentInput
     */
    public function getElvPaymentInput()
    {
        return $this->elvPaymentInput;
    }
    /**
     * Set elvPaymentInput value
     * @param \Docdata\StructType\ElvPaymentInput $elvPaymentInput
     * @return \Docdata\StructType\PaymentRequestInput
     */
    public function setElvPaymentInput(\Docdata\StructType\ElvPaymentInput $elvPaymentInput = null)
    {
        $this->elvPaymentInput = $elvPaymentInput;
        return $this;
    }
    /**
     * Get iDealPaymentInput value
     * @return \Docdata\StructType\IDealPaymentInput
     */
    public function getIDealPaymentInput()
    {
        return $this->iDealPaymentInput;
    }
    /**
     * Set iDealPaymentInput value
     * @param \Docdata\StructType\IDealPaymentInput $iDealPaymentInput
     * @return \Docdata\StructType\PaymentRequestInput
     */
    public function setIDealPaymentInput(\Docdata\StructType\IDealPaymentInput $iDealPaymentInput = null)
    {
        $this->iDealPaymentInput = $iDealPaymentInput;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\PaymentRequestInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
