<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for itemLine StructType
 * Meta informations extracted from the WSDL
 * - documentation: A code and quantity referring to an earlier supplied item.
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class ItemLine extends AbstractStructBase
{
    /**
     * The itemCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $itemCode;
    /**
     * The quantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $quantity;
    /**
     * Constructor method for itemLine
     * @uses ItemLine::setItemCode()
     * @uses ItemLine::setQuantity()
     * @param string $itemCode
     * @param int $quantity
     */
    public function __construct($itemCode = null, $quantity = null)
    {
        $this
            ->setItemCode($itemCode)
            ->setQuantity($quantity);
    }
    /**
     * Get itemCode value
     * @return string
     */
    public function getItemCode()
    {
        return $this->itemCode;
    }
    /**
     * Set itemCode value
     * @param string $itemCode
     * @return \Docdata\StructType\ItemLine
     */
    public function setItemCode($itemCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($itemCode) && strlen($itemCode) > 50) || (is_array($itemCode) && count($itemCode) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($itemCode) ? strlen($itemCode) : count($itemCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($itemCode) && strlen($itemCode) < 1) || (is_array($itemCode) && count($itemCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($itemCode) && !is_string($itemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemCode)), __LINE__);
        }
        $this->itemCode = $itemCode;
        return $this;
    }
    /**
     * Get quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \Docdata\StructType\ItemLine
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\ItemLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
