<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for iDealPaymentInput StructType
 * Meta informations extracted from the WSDL
 * - documentation: iDEAL payment input.
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class IDealPaymentInput extends AbstractStructBase
{
    /**
     * The issuerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: The iDEAL issuer id, for example RABO, ABNAMRO, ING, SNS. See the documentation for possible issuing banks.
     * @var string
     */
    public $issuerId;
    /**
     * Constructor method for iDealPaymentInput
     * @uses IDealPaymentInput::setIssuerId()
     * @param string $issuerId
     */
    public function __construct($issuerId = null)
    {
        $this
            ->setIssuerId($issuerId);
    }
    /**
     * Get issuerId value
     * @return string
     */
    public function getIssuerId()
    {
        return $this->issuerId;
    }
    /**
     * Set issuerId value
     * @param string $issuerId
     * @return \Docdata\StructType\IDealPaymentInput
     */
    public function setIssuerId($issuerId = null)
    {
        // validation for constraint: string
        if (!is_null($issuerId) && !is_string($issuerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuerId)), __LINE__);
        }
        $this->issuerId = $issuerId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\IDealPaymentInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
