<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Allows to request a new order to be registered.
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class CreateRequest extends AbstractStructBase
{
    /**
     * The merchant
     * Meta informations extracted from the WSDL
     * - documentation: Merchant credentials.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\Merchant
     */
    public $merchant;
    /**
     * The merchantOrderReference
     * Meta informations extracted from the WSDL
     * - documentation: Unique merchant reference to this order.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $merchantOrderReference;
    /**
     * The paymentPreferences
     * Meta informations extracted from the WSDL
     * - documentation: Preferences to use for this payment.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\PaymentPreferences
     */
    public $paymentPreferences;
    /**
     * The shopper
     * Meta informations extracted from the WSDL
     * - documentation: Information concerning the shopper who placed the order.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\Shopper
     */
    public $shopper;
    /**
     * The company
     * Meta informations extracted from the WSDL
     * - documentation: Information concerning the company which placed the order.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\Company
     */
    public $company;
    /**
     * The totalGrossAmount
     * Meta informations extracted from the WSDL
     * - documentation: Total order gross amount.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\Amount
     */
    public $totalGrossAmount;
    /**
     * The billTo
     * Meta informations extracted from the WSDL
     * - documentation: Name and address to use for billing.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\Destination
     */
    public $billTo;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - fixed: 1.3
     * - use: required
     * @var float
     */
    public $version;
    /**
     * The menuPreferences
     * Meta informations extracted from the WSDL
     * - documentation: Preferences to be used for the webmenu.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Docdata\StructType\MenuPreferences
     */
    public $menuPreferences;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: The description of the order.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $description;
    /**
     * The receiptText
     * Meta informations extracted from the WSDL
     * - documentation: The description that is used by payment providers on shopper statements.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $receiptText;
    /**
     * The includeCosts
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Indicates if the cost of the chosen payment method should be added (true) or should not be added (false) to the order amount. Default is false. Note that this will not work for every payment method. In the future, DocData may no
     * longer support this feature.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $includeCosts;
    /**
     * The paymentRequest
     * Meta informations extracted from the WSDL
     * - documentation: Optionally specifies a request. When it targets an existing previous payment, then that will be used to start a new payment with directly. If it does not point to a payment, then reservations are made as the starting point for
     * upcoming repeated payments. Using "start" with the request instead is highly recommended.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Docdata\StructType\PaymentRequest
     */
    public $paymentRequest;
    /**
     * The invoice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Docdata\StructType\Invoice
     */
    public $invoice;
    /**
     * The integrationInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Docdata\StructType\TechnicalIntegrationInfo
     */
    public $integrationInfo;
    /**
     * The salesPerson
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Docdata\StructType\SalesPerson
     */
    public $salesPerson;
    /**
     * The testExtensibility
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Test extensibility of client implementation by returning test elements and attributes indicated by with the names and string value "_any".
     * - use: optional
     * @var bool
     */
    public $testExtensibility;
    /**
     * Constructor method for createRequest
     * @uses CreateRequest::setMerchant()
     * @uses CreateRequest::setMerchantOrderReference()
     * @uses CreateRequest::setPaymentPreferences()
     * @uses CreateRequest::setShopper()
     * @uses CreateRequest::setCompany()
     * @uses CreateRequest::setTotalGrossAmount()
     * @uses CreateRequest::setBillTo()
     * @uses CreateRequest::setVersion()
     * @uses CreateRequest::setMenuPreferences()
     * @uses CreateRequest::setDescription()
     * @uses CreateRequest::setReceiptText()
     * @uses CreateRequest::setIncludeCosts()
     * @uses CreateRequest::setPaymentRequest()
     * @uses CreateRequest::setInvoice()
     * @uses CreateRequest::setIntegrationInfo()
     * @uses CreateRequest::setSalesPerson()
     * @uses CreateRequest::setTestExtensibility()
     * @param \Docdata\StructType\Merchant $merchant
     * @param string $merchantOrderReference
     * @param \Docdata\StructType\PaymentPreferences $paymentPreferences
     * @param \Docdata\StructType\Shopper $shopper
     * @param \Docdata\StructType\Company $company
     * @param \Docdata\StructType\Amount $totalGrossAmount
     * @param \Docdata\StructType\Destination $billTo
     * @param float $version
     * @param \Docdata\StructType\MenuPreferences $menuPreferences
     * @param string $description
     * @param string $receiptText
     * @param bool $includeCosts
     * @param \Docdata\StructType\PaymentRequest $paymentRequest
     * @param \Docdata\StructType\Invoice $invoice
     * @param \Docdata\StructType\TechnicalIntegrationInfo $integrationInfo
     * @param \Docdata\StructType\SalesPerson $salesPerson
     * @param bool $testExtensibility
     */
    public function __construct(\Docdata\StructType\Merchant $merchant = null, $merchantOrderReference = null, \Docdata\StructType\PaymentPreferences $paymentPreferences = null, \Docdata\StructType\Shopper $shopper = null, \Docdata\StructType\Company $company = null, \Docdata\StructType\Amount $totalGrossAmount = null, \Docdata\StructType\Destination $billTo = null, $version = null, \Docdata\StructType\MenuPreferences $menuPreferences = null, $description = null, $receiptText = null, $includeCosts = false, \Docdata\StructType\PaymentRequest $paymentRequest = null, \Docdata\StructType\Invoice $invoice = null, \Docdata\StructType\TechnicalIntegrationInfo $integrationInfo = null, \Docdata\StructType\SalesPerson $salesPerson = null, $testExtensibility = false)
    {
        $this
            ->setMerchant($merchant)
            ->setMerchantOrderReference($merchantOrderReference)
            ->setPaymentPreferences($paymentPreferences)
            ->setShopper($shopper)
            ->setCompany($company)
            ->setTotalGrossAmount($totalGrossAmount)
            ->setBillTo($billTo)
            ->setVersion($version)
            ->setMenuPreferences($menuPreferences)
            ->setDescription($description)
            ->setReceiptText($receiptText)
            ->setIncludeCosts($includeCosts)
            ->setPaymentRequest($paymentRequest)
            ->setInvoice($invoice)
            ->setIntegrationInfo($integrationInfo)
            ->setSalesPerson($salesPerson)
            ->setTestExtensibility($testExtensibility);
    }
    /**
     * Get merchant value
     * @return \Docdata\StructType\Merchant
     */
    public function getMerchant()
    {
        return $this->merchant;
    }
    /**
     * Set merchant value
     * @param \Docdata\StructType\Merchant $merchant
     * @return \Docdata\StructType\CreateRequest
     */
    public function setMerchant(\Docdata\StructType\Merchant $merchant = null)
    {
        $this->merchant = $merchant;
        return $this;
    }
    /**
     * Get merchantOrderReference value
     * @return string
     */
    public function getMerchantOrderReference()
    {
        return $this->merchantOrderReference;
    }
    /**
     * Set merchantOrderReference value
     * @param string $merchantOrderReference
     * @return \Docdata\StructType\CreateRequest
     */
    public function setMerchantOrderReference($merchantOrderReference = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($merchantOrderReference) && strlen($merchantOrderReference) > 255) || (is_array($merchantOrderReference) && count($merchantOrderReference) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($merchantOrderReference) ? strlen($merchantOrderReference) : count($merchantOrderReference)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($merchantOrderReference) && strlen($merchantOrderReference) < 1) || (is_array($merchantOrderReference) && count($merchantOrderReference) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($merchantOrderReference) && !is_string($merchantOrderReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($merchantOrderReference)), __LINE__);
        }
        $this->merchantOrderReference = $merchantOrderReference;
        return $this;
    }
    /**
     * Get paymentPreferences value
     * @return \Docdata\StructType\PaymentPreferences
     */
    public function getPaymentPreferences()
    {
        return $this->paymentPreferences;
    }
    /**
     * Set paymentPreferences value
     * @param \Docdata\StructType\PaymentPreferences $paymentPreferences
     * @return \Docdata\StructType\CreateRequest
     */
    public function setPaymentPreferences(\Docdata\StructType\PaymentPreferences $paymentPreferences = null)
    {
        $this->paymentPreferences = $paymentPreferences;
        return $this;
    }
    /**
     * Get shopper value
     * @return \Docdata\StructType\Shopper
     */
    public function getShopper()
    {
        return $this->shopper;
    }
    /**
     * Set shopper value
     * @param \Docdata\StructType\Shopper $shopper
     * @return \Docdata\StructType\CreateRequest
     */
    public function setShopper(\Docdata\StructType\Shopper $shopper = null)
    {
        $this->shopper = $shopper;
        return $this;
    }
    /**
     * Get company value
     * @return \Docdata\StructType\Company
     */
    public function getCompany()
    {
        return $this->company;
    }
    /**
     * Set company value
     * @param \Docdata\StructType\Company $company
     * @return \Docdata\StructType\CreateRequest
     */
    public function setCompany(\Docdata\StructType\Company $company = null)
    {
        $this->company = $company;
        return $this;
    }
    /**
     * Get totalGrossAmount value
     * @return \Docdata\StructType\Amount
     */
    public function getTotalGrossAmount()
    {
        return $this->totalGrossAmount;
    }
    /**
     * Set totalGrossAmount value
     * @param \Docdata\StructType\Amount $totalGrossAmount
     * @return \Docdata\StructType\CreateRequest
     */
    public function setTotalGrossAmount(\Docdata\StructType\Amount $totalGrossAmount = null)
    {
        $this->totalGrossAmount = $totalGrossAmount;
        return $this;
    }
    /**
     * Get billTo value
     * @return \Docdata\StructType\Destination
     */
    public function getBillTo()
    {
        return $this->billTo;
    }
    /**
     * Set billTo value
     * @param \Docdata\StructType\Destination $billTo
     * @return \Docdata\StructType\CreateRequest
     */
    public function setBillTo(\Docdata\StructType\Destination $billTo = null)
    {
        $this->billTo = $billTo;
        return $this;
    }
    /**
     * Get version value
     * @return float
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param float $version
     * @return \Docdata\StructType\CreateRequest
     */
    public function setVersion($version = null)
    {
        $this->version = $version;
        return $this;
    }
    /**
     * Get menuPreferences value
     * @return \Docdata\StructType\MenuPreferences|null
     */
    public function getMenuPreferences()
    {
        return $this->menuPreferences;
    }
    /**
     * Set menuPreferences value
     * @param \Docdata\StructType\MenuPreferences $menuPreferences
     * @return \Docdata\StructType\CreateRequest
     */
    public function setMenuPreferences(\Docdata\StructType\MenuPreferences $menuPreferences = null)
    {
        $this->menuPreferences = $menuPreferences;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Docdata\StructType\CreateRequest
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($description) && strlen($description) < 1) || (is_array($description) && count($description) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get receiptText value
     * @return string|null
     */
    public function getReceiptText()
    {
        return $this->receiptText;
    }
    /**
     * Set receiptText value
     * @param string $receiptText
     * @return \Docdata\StructType\CreateRequest
     */
    public function setReceiptText($receiptText = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($receiptText) && strlen($receiptText) > 50) || (is_array($receiptText) && count($receiptText) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($receiptText) ? strlen($receiptText) : count($receiptText)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($receiptText) && strlen($receiptText) < 1) || (is_array($receiptText) && count($receiptText) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($receiptText) && !is_string($receiptText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiptText)), __LINE__);
        }
        $this->receiptText = $receiptText;
        return $this;
    }
    /**
     * Get includeCosts value
     * @return bool|null
     */
    public function getIncludeCosts()
    {
        return $this->includeCosts;
    }
    /**
     * Set includeCosts value
     * @param bool $includeCosts
     * @return \Docdata\StructType\CreateRequest
     */
    public function setIncludeCosts($includeCosts = false)
    {
        $this->includeCosts = $includeCosts;
        return $this;
    }
    /**
     * Get paymentRequest value
     * @return \Docdata\StructType\PaymentRequest|null
     */
    public function getPaymentRequest()
    {
        return $this->paymentRequest;
    }
    /**
     * Set paymentRequest value
     * @param \Docdata\StructType\PaymentRequest $paymentRequest
     * @return \Docdata\StructType\CreateRequest
     */
    public function setPaymentRequest(\Docdata\StructType\PaymentRequest $paymentRequest = null)
    {
        $this->paymentRequest = $paymentRequest;
        return $this;
    }
    /**
     * Get invoice value
     * @return \Docdata\StructType\Invoice|null
     */
    public function getInvoice()
    {
        return $this->invoice;
    }
    /**
     * Set invoice value
     * @param \Docdata\StructType\Invoice $invoice
     * @return \Docdata\StructType\CreateRequest
     */
    public function setInvoice(\Docdata\StructType\Invoice $invoice = null)
    {
        $this->invoice = $invoice;
        return $this;
    }
    /**
     * Get integrationInfo value
     * @return \Docdata\StructType\TechnicalIntegrationInfo|null
     */
    public function getIntegrationInfo()
    {
        return $this->integrationInfo;
    }
    /**
     * Set integrationInfo value
     * @param \Docdata\StructType\TechnicalIntegrationInfo $integrationInfo
     * @return \Docdata\StructType\CreateRequest
     */
    public function setIntegrationInfo(\Docdata\StructType\TechnicalIntegrationInfo $integrationInfo = null)
    {
        $this->integrationInfo = $integrationInfo;
        return $this;
    }
    /**
     * Get salesPerson value
     * @return \Docdata\StructType\SalesPerson|null
     */
    public function getSalesPerson()
    {
        return $this->salesPerson;
    }
    /**
     * Set salesPerson value
     * @param \Docdata\StructType\SalesPerson $salesPerson
     * @return \Docdata\StructType\CreateRequest
     */
    public function setSalesPerson(\Docdata\StructType\SalesPerson $salesPerson = null)
    {
        $this->salesPerson = $salesPerson;
        return $this;
    }
    /**
     * Get testExtensibility value
     * @return bool|null
     */
    public function getTestExtensibility()
    {
        return $this->testExtensibility;
    }
    /**
     * Set testExtensibility value
     * @param bool $testExtensibility
     * @return \Docdata\StructType\CreateRequest
     */
    public function setTestExtensibility($testExtensibility = false)
    {
        $this->testExtensibility = $testExtensibility;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\CreateRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
