<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for captureRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Allows to request capture of an amount for a payment authorization.
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class CaptureRequest extends AbstractStructBase
{
    /**
     * The merchant
     * Meta informations extracted from the WSDL
     * - documentation: Merchant's credentials.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\Merchant
     */
    public $merchant;
    /**
     * The paymentId
     * Meta informations extracted from the WSDL
     * - documentation: Payment id with check digit identifying the payment. | The payment ID with check digit as generated by the payment system.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $paymentId;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - fixed: 1.3
     * - use: required
     * @var float
     */
    public $version;
    /**
     * The merchantCaptureReference
     * Meta informations extracted from the WSDL
     * - documentation: Merchant's internal ID for identifying this capture. Will be returned in the capture response and in status reports.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $merchantCaptureReference;
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - documentation: Amount to be captured. If no amount nor an order item code is specified, the capture will be done for the order's total amount.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Docdata\StructType\Amount
     */
    public $amount;
    /**
     * The itemCode
     * Meta informations extracted from the WSDL
     * - documentation: A code or article number identifying an item in the order. If specified, this order item's total (gross) amount will be used for this capture's amount and currency.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $itemCode;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: Optional description for this capture.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 250
     * - minLength: 1
     * @var string
     */
    public $description;
    /**
     * The finalCapture
     * Meta informations extracted from the WSDL
     * - documentation: Indicator whether this is the final capture for this order.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $finalCapture;
    /**
     * The cancelReserved
     * Meta informations extracted from the WSDL
     * - documentation: Indicator if any reserved (new) captures should be canceled in favor of this capture. Must always be true for captures.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $cancelReserved;
    /**
     * The requiredCaptureDate
     * Meta informations extracted from the WSDL
     * - documentation: The date on which to capture. The first opportunity after this date for a capture will be used. The default is as soon as possible.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $requiredCaptureDate;
    /**
     * The integrationInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Docdata\StructType\TechnicalIntegrationInfo
     */
    public $integrationInfo;
    /**
     * The testExtensibility
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Test extensibility of client implementation by returning test elements and attributes indicated by with the names and string value "_any".
     * - use: optional
     * @var bool
     */
    public $testExtensibility;
    /**
     * Constructor method for captureRequest
     * @uses CaptureRequest::setMerchant()
     * @uses CaptureRequest::setPaymentId()
     * @uses CaptureRequest::setVersion()
     * @uses CaptureRequest::setMerchantCaptureReference()
     * @uses CaptureRequest::setAmount()
     * @uses CaptureRequest::setItemCode()
     * @uses CaptureRequest::setDescription()
     * @uses CaptureRequest::setFinalCapture()
     * @uses CaptureRequest::setCancelReserved()
     * @uses CaptureRequest::setRequiredCaptureDate()
     * @uses CaptureRequest::setIntegrationInfo()
     * @uses CaptureRequest::setTestExtensibility()
     * @param \Docdata\StructType\Merchant $merchant
     * @param int $paymentId
     * @param float $version
     * @param string $merchantCaptureReference
     * @param \Docdata\StructType\Amount $amount
     * @param string $itemCode
     * @param string $description
     * @param bool $finalCapture
     * @param bool $cancelReserved
     * @param string $requiredCaptureDate
     * @param \Docdata\StructType\TechnicalIntegrationInfo $integrationInfo
     * @param bool $testExtensibility
     */
    public function __construct(\Docdata\StructType\Merchant $merchant = null, $paymentId = null, $version = null, $merchantCaptureReference = null, \Docdata\StructType\Amount $amount = null, $itemCode = null, $description = null, $finalCapture = null, $cancelReserved = null, $requiredCaptureDate = null, \Docdata\StructType\TechnicalIntegrationInfo $integrationInfo = null, $testExtensibility = false)
    {
        $this
            ->setMerchant($merchant)
            ->setPaymentId($paymentId)
            ->setVersion($version)
            ->setMerchantCaptureReference($merchantCaptureReference)
            ->setAmount($amount)
            ->setItemCode($itemCode)
            ->setDescription($description)
            ->setFinalCapture($finalCapture)
            ->setCancelReserved($cancelReserved)
            ->setRequiredCaptureDate($requiredCaptureDate)
            ->setIntegrationInfo($integrationInfo)
            ->setTestExtensibility($testExtensibility);
    }
    /**
     * Get merchant value
     * @return \Docdata\StructType\Merchant
     */
    public function getMerchant()
    {
        return $this->merchant;
    }
    /**
     * Set merchant value
     * @param \Docdata\StructType\Merchant $merchant
     * @return \Docdata\StructType\CaptureRequest
     */
    public function setMerchant(\Docdata\StructType\Merchant $merchant = null)
    {
        $this->merchant = $merchant;
        return $this;
    }
    /**
     * Get paymentId value
     * @return int
     */
    public function getPaymentId()
    {
        return $this->paymentId;
    }
    /**
     * Set paymentId value
     * @param int $paymentId
     * @return \Docdata\StructType\CaptureRequest
     */
    public function setPaymentId($paymentId = null)
    {
        // validation for constraint: int
        if (!is_null($paymentId) && !is_numeric($paymentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentId)), __LINE__);
        }
        $this->paymentId = $paymentId;
        return $this;
    }
    /**
     * Get version value
     * @return float
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param float $version
     * @return \Docdata\StructType\CaptureRequest
     */
    public function setVersion($version = null)
    {
        $this->version = $version;
        return $this;
    }
    /**
     * Get merchantCaptureReference value
     * @return string|null
     */
    public function getMerchantCaptureReference()
    {
        return $this->merchantCaptureReference;
    }
    /**
     * Set merchantCaptureReference value
     * @param string $merchantCaptureReference
     * @return \Docdata\StructType\CaptureRequest
     */
    public function setMerchantCaptureReference($merchantCaptureReference = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($merchantCaptureReference) && strlen($merchantCaptureReference) > 35) || (is_array($merchantCaptureReference) && count($merchantCaptureReference) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($merchantCaptureReference) ? strlen($merchantCaptureReference) : count($merchantCaptureReference)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($merchantCaptureReference) && strlen($merchantCaptureReference) < 1) || (is_array($merchantCaptureReference) && count($merchantCaptureReference) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($merchantCaptureReference) && !is_string($merchantCaptureReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($merchantCaptureReference)), __LINE__);
        }
        $this->merchantCaptureReference = $merchantCaptureReference;
        return $this;
    }
    /**
     * Get amount value
     * @return \Docdata\StructType\Amount|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param \Docdata\StructType\Amount $amount
     * @return \Docdata\StructType\CaptureRequest
     */
    public function setAmount(\Docdata\StructType\Amount $amount = null)
    {
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get itemCode value
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->itemCode;
    }
    /**
     * Set itemCode value
     * @param string $itemCode
     * @return \Docdata\StructType\CaptureRequest
     */
    public function setItemCode($itemCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($itemCode) && strlen($itemCode) > 50) || (is_array($itemCode) && count($itemCode) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($itemCode) ? strlen($itemCode) : count($itemCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($itemCode) && strlen($itemCode) < 1) || (is_array($itemCode) && count($itemCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($itemCode) && !is_string($itemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemCode)), __LINE__);
        }
        $this->itemCode = $itemCode;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Docdata\StructType\CaptureRequest
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 250) || (is_array($description) && count($description) > 250)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 250 element(s) or a scalar of 250 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($description) && strlen($description) < 1) || (is_array($description) && count($description) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get finalCapture value
     * @return bool|null
     */
    public function getFinalCapture()
    {
        return $this->finalCapture;
    }
    /**
     * Set finalCapture value
     * @param bool $finalCapture
     * @return \Docdata\StructType\CaptureRequest
     */
    public function setFinalCapture($finalCapture = null)
    {
        $this->finalCapture = $finalCapture;
        return $this;
    }
    /**
     * Get cancelReserved value
     * @return bool|null
     */
    public function getCancelReserved()
    {
        return $this->cancelReserved;
    }
    /**
     * Set cancelReserved value
     * @param bool $cancelReserved
     * @return \Docdata\StructType\CaptureRequest
     */
    public function setCancelReserved($cancelReserved = null)
    {
        $this->cancelReserved = $cancelReserved;
        return $this;
    }
    /**
     * Get requiredCaptureDate value
     * @return string|null
     */
    public function getRequiredCaptureDate()
    {
        return $this->requiredCaptureDate;
    }
    /**
     * Set requiredCaptureDate value
     * @param string $requiredCaptureDate
     * @return \Docdata\StructType\CaptureRequest
     */
    public function setRequiredCaptureDate($requiredCaptureDate = null)
    {
        // validation for constraint: string
        if (!is_null($requiredCaptureDate) && !is_string($requiredCaptureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requiredCaptureDate)), __LINE__);
        }
        $this->requiredCaptureDate = $requiredCaptureDate;
        return $this;
    }
    /**
     * Get integrationInfo value
     * @return \Docdata\StructType\TechnicalIntegrationInfo|null
     */
    public function getIntegrationInfo()
    {
        return $this->integrationInfo;
    }
    /**
     * Set integrationInfo value
     * @param \Docdata\StructType\TechnicalIntegrationInfo $integrationInfo
     * @return \Docdata\StructType\CaptureRequest
     */
    public function setIntegrationInfo(\Docdata\StructType\TechnicalIntegrationInfo $integrationInfo = null)
    {
        $this->integrationInfo = $integrationInfo;
        return $this;
    }
    /**
     * Get testExtensibility value
     * @return bool|null
     */
    public function getTestExtensibility()
    {
        return $this->testExtensibility;
    }
    /**
     * Set testExtensibility value
     * @param bool $testExtensibility
     * @return \Docdata\StructType\CaptureRequest
     */
    public function setTestExtensibility($testExtensibility = false)
    {
        $this->testExtensibility = $testExtensibility;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\CaptureRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
