<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for authorization StructType
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class Authorization extends AbstractStructBase
{
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $status;
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\Amount
     */
    public $amount;
    /**
     * The confidenceLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $confidenceLevel;
    /**
     * The reason
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 250
     * - minLength: 1
     * @var string
     */
    public $reason;
    /**
     * The capture
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Docdata\StructType\Capture[]
     */
    public $capture;
    /**
     * The refund
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Docdata\StructType\Refund[]
     */
    public $refund;
    /**
     * The chargeback
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Docdata\StructType\Chargeback[]
     */
    public $chargeback;
    /**
     * The reversal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Docdata\StructType\Reversal
     */
    public $reversal;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for authorization
     * @uses Authorization::setStatus()
     * @uses Authorization::setAmount()
     * @uses Authorization::setConfidenceLevel()
     * @uses Authorization::setReason()
     * @uses Authorization::setCapture()
     * @uses Authorization::setRefund()
     * @uses Authorization::setChargeback()
     * @uses Authorization::setReversal()
     * @uses Authorization::setAny()
     * @param string $status
     * @param \Docdata\StructType\Amount $amount
     * @param string $confidenceLevel
     * @param string $reason
     * @param \Docdata\StructType\Capture[] $capture
     * @param \Docdata\StructType\Refund[] $refund
     * @param \Docdata\StructType\Chargeback[] $chargeback
     * @param \Docdata\StructType\Reversal $reversal
     * @param \DOMDocument $any
     */
    public function __construct($status = null, \Docdata\StructType\Amount $amount = null, $confidenceLevel = null, $reason = null, array $capture = array(), array $refund = array(), array $chargeback = array(), \Docdata\StructType\Reversal $reversal = null, \DOMDocument $any = null)
    {
        $this
            ->setStatus($status)
            ->setAmount($amount)
            ->setConfidenceLevel($confidenceLevel)
            ->setReason($reason)
            ->setCapture($capture)
            ->setRefund($refund)
            ->setChargeback($chargeback)
            ->setReversal($reversal)
            ->setAny($any);
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \Docdata\EnumType\AuthorizationStatus::valueIsValid()
     * @uses \Docdata\EnumType\AuthorizationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \Docdata\StructType\Authorization
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\Docdata\EnumType\AuthorizationStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \Docdata\EnumType\AuthorizationStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get amount value
     * @return \Docdata\StructType\Amount
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param \Docdata\StructType\Amount $amount
     * @return \Docdata\StructType\Authorization
     */
    public function setAmount(\Docdata\StructType\Amount $amount = null)
    {
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get confidenceLevel value
     * @return string
     */
    public function getConfidenceLevel()
    {
        return $this->confidenceLevel;
    }
    /**
     * Set confidenceLevel value
     * @param string $confidenceLevel
     * @return \Docdata\StructType\Authorization
     */
    public function setConfidenceLevel($confidenceLevel = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($confidenceLevel) && strlen($confidenceLevel) > 35) || (is_array($confidenceLevel) && count($confidenceLevel) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($confidenceLevel) ? strlen($confidenceLevel) : count($confidenceLevel)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($confidenceLevel) && strlen($confidenceLevel) < 1) || (is_array($confidenceLevel) && count($confidenceLevel) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($confidenceLevel) && !is_string($confidenceLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($confidenceLevel)), __LINE__);
        }
        $this->confidenceLevel = $confidenceLevel;
        return $this;
    }
    /**
     * Get reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * Set reason value
     * @param string $reason
     * @return \Docdata\StructType\Authorization
     */
    public function setReason($reason = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($reason) && strlen($reason) > 250) || (is_array($reason) && count($reason) > 250)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 250 element(s) or a scalar of 250 character(s) at most, "%d" length given', is_scalar($reason) ? strlen($reason) : count($reason)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($reason) && strlen($reason) < 1) || (is_array($reason) && count($reason) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reason)), __LINE__);
        }
        $this->reason = $reason;
        return $this;
    }
    /**
     * Get capture value
     * @return \Docdata\StructType\Capture[]|null
     */
    public function getCapture()
    {
        return $this->capture;
    }
    /**
     * Set capture value
     * @throws \InvalidArgumentException
     * @param \Docdata\StructType\Capture[] $capture
     * @return \Docdata\StructType\Authorization
     */
    public function setCapture(array $capture = array())
    {
        foreach ($capture as $authorizationCaptureItem) {
            // validation for constraint: itemType
            if (!$authorizationCaptureItem instanceof \Docdata\StructType\Capture) {
                throw new \InvalidArgumentException(sprintf('The capture property can only contain items of \Docdata\StructType\Capture, "%s" given', is_object($authorizationCaptureItem) ? get_class($authorizationCaptureItem) : gettype($authorizationCaptureItem)), __LINE__);
            }
        }
        $this->capture = $capture;
        return $this;
    }
    /**
     * Add item to capture value
     * @throws \InvalidArgumentException
     * @param \Docdata\StructType\Capture $item
     * @return \Docdata\StructType\Authorization
     */
    public function addToCapture(\Docdata\StructType\Capture $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Docdata\StructType\Capture) {
            throw new \InvalidArgumentException(sprintf('The capture property can only contain items of \Docdata\StructType\Capture, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->capture[] = $item;
        return $this;
    }
    /**
     * Get refund value
     * @return \Docdata\StructType\Refund[]|null
     */
    public function getRefund()
    {
        return $this->refund;
    }
    /**
     * Set refund value
     * @throws \InvalidArgumentException
     * @param \Docdata\StructType\Refund[] $refund
     * @return \Docdata\StructType\Authorization
     */
    public function setRefund(array $refund = array())
    {
        foreach ($refund as $authorizationRefundItem) {
            // validation for constraint: itemType
            if (!$authorizationRefundItem instanceof \Docdata\StructType\Refund) {
                throw new \InvalidArgumentException(sprintf('The refund property can only contain items of \Docdata\StructType\Refund, "%s" given', is_object($authorizationRefundItem) ? get_class($authorizationRefundItem) : gettype($authorizationRefundItem)), __LINE__);
            }
        }
        $this->refund = $refund;
        return $this;
    }
    /**
     * Add item to refund value
     * @throws \InvalidArgumentException
     * @param \Docdata\StructType\Refund $item
     * @return \Docdata\StructType\Authorization
     */
    public function addToRefund(\Docdata\StructType\Refund $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Docdata\StructType\Refund) {
            throw new \InvalidArgumentException(sprintf('The refund property can only contain items of \Docdata\StructType\Refund, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->refund[] = $item;
        return $this;
    }
    /**
     * Get chargeback value
     * @return \Docdata\StructType\Chargeback[]|null
     */
    public function getChargeback()
    {
        return $this->chargeback;
    }
    /**
     * Set chargeback value
     * @throws \InvalidArgumentException
     * @param \Docdata\StructType\Chargeback[] $chargeback
     * @return \Docdata\StructType\Authorization
     */
    public function setChargeback(array $chargeback = array())
    {
        foreach ($chargeback as $authorizationChargebackItem) {
            // validation for constraint: itemType
            if (!$authorizationChargebackItem instanceof \Docdata\StructType\Chargeback) {
                throw new \InvalidArgumentException(sprintf('The chargeback property can only contain items of \Docdata\StructType\Chargeback, "%s" given', is_object($authorizationChargebackItem) ? get_class($authorizationChargebackItem) : gettype($authorizationChargebackItem)), __LINE__);
            }
        }
        $this->chargeback = $chargeback;
        return $this;
    }
    /**
     * Add item to chargeback value
     * @throws \InvalidArgumentException
     * @param \Docdata\StructType\Chargeback $item
     * @return \Docdata\StructType\Authorization
     */
    public function addToChargeback(\Docdata\StructType\Chargeback $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Docdata\StructType\Chargeback) {
            throw new \InvalidArgumentException(sprintf('The chargeback property can only contain items of \Docdata\StructType\Chargeback, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->chargeback[] = $item;
        return $this;
    }
    /**
     * Get reversal value
     * @return \Docdata\StructType\Reversal|null
     */
    public function getReversal()
    {
        return $this->reversal;
    }
    /**
     * Set reversal value
     * @param \Docdata\StructType\Reversal $reversal
     * @return \Docdata\StructType\Authorization
     */
    public function setReversal(\Docdata\StructType\Reversal $reversal = null)
    {
        $this->reversal = $reversal;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Docdata\StructType\Authorization::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Docdata\StructType\Authorization
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\Authorization
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
