<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for additionalRefund StructType
 * Meta informations extracted from the WSDL
 * - documentation: Additional amount to refund when refunding an order.
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class AdditionalRefund extends AbstractStructBase
{
    /**
     * The additionalAmount
     * Meta informations extracted from the WSDL
     * - documentation: The amount to refund additionally, including VAT.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\Amount
     */
    public $additionalAmount;
    /**
     * The vatRate
     * Meta informations extracted from the WSDL
     * - documentation: The VAT rate of the additionally refunded amount.
     * - use: required
     * - minInclusive: 0
     * - whiteSpace: collapse
     * @var float
     */
    public $vatRate;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: Optional description for this refund.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 250
     * - minLength: 1
     * @var string
     */
    public $description;
    /**
     * Constructor method for additionalRefund
     * @uses AdditionalRefund::setAdditionalAmount()
     * @uses AdditionalRefund::setVatRate()
     * @uses AdditionalRefund::setDescription()
     * @param \Docdata\StructType\Amount $additionalAmount
     * @param float $vatRate
     * @param string $description
     */
    public function __construct(\Docdata\StructType\Amount $additionalAmount = null, $vatRate = null, $description = null)
    {
        $this
            ->setAdditionalAmount($additionalAmount)
            ->setVatRate($vatRate)
            ->setDescription($description);
    }
    /**
     * Get additionalAmount value
     * @return \Docdata\StructType\Amount
     */
    public function getAdditionalAmount()
    {
        return $this->additionalAmount;
    }
    /**
     * Set additionalAmount value
     * @param \Docdata\StructType\Amount $additionalAmount
     * @return \Docdata\StructType\AdditionalRefund
     */
    public function setAdditionalAmount(\Docdata\StructType\Amount $additionalAmount = null)
    {
        $this->additionalAmount = $additionalAmount;
        return $this;
    }
    /**
     * Get vatRate value
     * @return float
     */
    public function getVatRate()
    {
        return $this->vatRate;
    }
    /**
     * Set vatRate value
     * @param float $vatRate
     * @return \Docdata\StructType\AdditionalRefund
     */
    public function setVatRate($vatRate = null)
    {
        $this->vatRate = $vatRate;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Docdata\StructType\AdditionalRefund
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 250) || (is_array($description) && count($description) > 250)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 250 element(s) or a scalar of 250 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($description) && strlen($description) < 1) || (is_array($description) && count($description) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\AdditionalRefund
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
