<?php

namespace Docdata\EnumType;

/**
 * This class stands for reason EnumType
 * Meta informations extracted from the WSDL
 * - documentation: The error code of the error. Considered safe based on exact match. Considered safe based on match within margin (but less than expected). Considered safe based on match within margin (but more than expected). Considered safe, but too
 * much, since more than expected and outside margin. Considered safe based on manual action by user.
 * @subpackage Enumerations
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class Reason
{
    /**
     * Constant for value 'EXACT_MATCH'
     * @return string 'EXACT_MATCH'
     */
    const VALUE_EXACT_MATCH = 'EXACT_MATCH';
    /**
     * Constant for value 'MARGIN_MATCH_LESS'
     * @return string 'MARGIN_MATCH_LESS'
     */
    const VALUE_MARGIN_MATCH_LESS = 'MARGIN_MATCH_LESS';
    /**
     * Constant for value 'MARGIN_MATCH_MORE'
     * @return string 'MARGIN_MATCH_MORE'
     */
    const VALUE_MARGIN_MATCH_MORE = 'MARGIN_MATCH_MORE';
    /**
     * Constant for value 'TOO_MUCH'
     * @return string 'TOO_MUCH'
     */
    const VALUE_TOO_MUCH = 'TOO_MUCH';
    /**
     * Constant for value 'MANUAL'
     * @return string 'MANUAL'
     */
    const VALUE_MANUAL = 'MANUAL';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EXACT_MATCH
     * @uses self::VALUE_MARGIN_MATCH_LESS
     * @uses self::VALUE_MARGIN_MATCH_MORE
     * @uses self::VALUE_TOO_MUCH
     * @uses self::VALUE_MANUAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EXACT_MATCH,
            self::VALUE_MARGIN_MATCH_LESS,
            self::VALUE_MARGIN_MATCH_MORE,
            self::VALUE_TOO_MUCH,
            self::VALUE_MANUAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
