<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for startResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: Response to a start request.
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class StartResponse extends AbstractStructBase
{
    /**
     * The startErrors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\StartErrors
     */
    public $startErrors;
    /**
     * The startSuccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\StartSuccess
     */
    public $startSuccess;
    /**
     * The ddpXsdVersion
     * Meta informations extracted from the WSDL
     * - use: required
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $ddpXsdVersion;
    /**
     * Constructor method for startResponse
     * @uses StartResponse::setStartErrors()
     * @uses StartResponse::setStartSuccess()
     * @uses StartResponse::setDdpXsdVersion()
     * @param \Docdata\StructType\StartErrors $startErrors
     * @param \Docdata\StructType\StartSuccess $startSuccess
     * @param string $ddpXsdVersion
     */
    public function __construct(\Docdata\StructType\StartErrors $startErrors = null, \Docdata\StructType\StartSuccess $startSuccess = null, $ddpXsdVersion = null)
    {
        $this
            ->setStartErrors($startErrors)
            ->setStartSuccess($startSuccess)
            ->setDdpXsdVersion($ddpXsdVersion);
    }
    /**
     * Get startErrors value
     * @return \Docdata\StructType\StartErrors
     */
    public function getStartErrors()
    {
        return $this->startErrors;
    }
    /**
     * Set startErrors value
     * @param \Docdata\StructType\StartErrors $startErrors
     * @return \Docdata\StructType\StartResponse
     */
    public function setStartErrors(\Docdata\StructType\StartErrors $startErrors = null)
    {
        $this->startErrors = $startErrors;
        return $this;
    }
    /**
     * Get startSuccess value
     * @return \Docdata\StructType\StartSuccess
     */
    public function getStartSuccess()
    {
        return $this->startSuccess;
    }
    /**
     * Set startSuccess value
     * @param \Docdata\StructType\StartSuccess $startSuccess
     * @return \Docdata\StructType\StartResponse
     */
    public function setStartSuccess(\Docdata\StructType\StartSuccess $startSuccess = null)
    {
        $this->startSuccess = $startSuccess;
        return $this;
    }
    /**
     * Get ddpXsdVersion value
     * @return string
     */
    public function getDdpXsdVersion()
    {
        return $this->ddpXsdVersion;
    }
    /**
     * Set ddpXsdVersion value
     * @param string $ddpXsdVersion
     * @return \Docdata\StructType\StartResponse
     */
    public function setDdpXsdVersion($ddpXsdVersion = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ddpXsdVersion) && strlen($ddpXsdVersion) > 35) || (is_array($ddpXsdVersion) && count($ddpXsdVersion) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($ddpXsdVersion) ? strlen($ddpXsdVersion) : count($ddpXsdVersion)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($ddpXsdVersion) && strlen($ddpXsdVersion) < 1) || (is_array($ddpXsdVersion) && count($ddpXsdVersion) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ddpXsdVersion) && !is_string($ddpXsdVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ddpXsdVersion)), __LINE__);
        }
        $this->ddpXsdVersion = $ddpXsdVersion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\StartResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
