<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paymentReference StructType
 * Meta informations extracted from the WSDL
 * - documentation: A reference identifying an initial payment.
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class PaymentReference extends AbstractStructBase
{
    /**
     * The linkId
     * Meta informations extracted from the WSDL
     * - documentation: A linkID token, which is a UUID type 4 (see RFC-4122 and ITU-T Rec. X.667). | A UUID type 4 token, which is compliant with RFC-4122 and ITU-T Rec. X.667. See also https://en.wikipedia.org/wiki/Universally_unique_identifier#Definition
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-4[0-9a-fA-F]{3}-[89aAbB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}
     * @var string
     */
    public $linkId;
    /**
     * The paymentId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: The payment ID with check digit as generated by the payment system.
     * @var int
     */
    public $paymentId;
    /**
     * The merchantReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $merchantReference;
    /**
     * Constructor method for paymentReference
     * @uses PaymentReference::setLinkId()
     * @uses PaymentReference::setPaymentId()
     * @uses PaymentReference::setMerchantReference()
     * @param string $linkId
     * @param int $paymentId
     * @param string $merchantReference
     */
    public function __construct($linkId = null, $paymentId = null, $merchantReference = null)
    {
        $this
            ->setLinkId($linkId)
            ->setPaymentId($paymentId)
            ->setMerchantReference($merchantReference);
    }
    /**
     * Get linkId value
     * @return string
     */
    public function getLinkId()
    {
        return $this->linkId;
    }
    /**
     * Set linkId value
     * @param string $linkId
     * @return \Docdata\StructType\PaymentReference
     */
    public function setLinkId($linkId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($linkId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-4[0-9a-fA-F]{3}-[89aAbB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}/', $linkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-4[0-9a-fA-F]{3}-[89aAbB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}", "%s" given', var_export($linkId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($linkId) && !is_string($linkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($linkId)), __LINE__);
        }
        $this->linkId = $linkId;
        return $this;
    }
    /**
     * Get paymentId value
     * @return int
     */
    public function getPaymentId()
    {
        return $this->paymentId;
    }
    /**
     * Set paymentId value
     * @param int $paymentId
     * @return \Docdata\StructType\PaymentReference
     */
    public function setPaymentId($paymentId = null)
    {
        // validation for constraint: int
        if (!is_null($paymentId) && !is_numeric($paymentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentId)), __LINE__);
        }
        $this->paymentId = $paymentId;
        return $this;
    }
    /**
     * Get merchantReference value
     * @return string
     */
    public function getMerchantReference()
    {
        return $this->merchantReference;
    }
    /**
     * Set merchantReference value
     * @param string $merchantReference
     * @return \Docdata\StructType\PaymentReference
     */
    public function setMerchantReference($merchantReference = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($merchantReference) && strlen($merchantReference) > 50) || (is_array($merchantReference) && count($merchantReference) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($merchantReference) ? strlen($merchantReference) : count($merchantReference)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($merchantReference) && strlen($merchantReference) < 1) || (is_array($merchantReference) && count($merchantReference) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($merchantReference) && !is_string($merchantReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($merchantReference)), __LINE__);
        }
        $this->merchantReference = $merchantReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\PaymentReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
