<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paymentRedirect StructType
 * Meta informations extracted from the WSDL
 * - documentation: Redirect instructions.
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class PaymentRedirect extends AbstractStructBase
{
    /**
     * The method
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: HTTP method
     * - pattern: GET|POST|PUT|DELETE|HEAD|TRACE|OPTIONS
     * @var string
     */
    public $method;
    /**
     * The url
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 2048
     * - minLength: 1
     * @var string
     */
    public $url;
    /**
     * The parameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\Parameters
     */
    public $parameters;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for paymentRedirect
     * @uses PaymentRedirect::setMethod()
     * @uses PaymentRedirect::setUrl()
     * @uses PaymentRedirect::setParameters()
     * @uses PaymentRedirect::setAny()
     * @param string $method
     * @param string $url
     * @param \Docdata\StructType\Parameters $parameters
     * @param \DOMDocument $any
     */
    public function __construct($method = null, $url = null, \Docdata\StructType\Parameters $parameters = null, \DOMDocument $any = null)
    {
        $this
            ->setMethod($method)
            ->setUrl($url)
            ->setParameters($parameters)
            ->setAny($any);
    }
    /**
     * Get method value
     * @return string
     */
    public function getMethod()
    {
        return $this->method;
    }
    /**
     * Set method value
     * @param string $method
     * @return \Docdata\StructType\PaymentRedirect
     */
    public function setMethod($method = null)
    {
        // validation for constraint: pattern
        if (is_scalar($method) && !preg_match('/GET|POST|PUT|DELETE|HEAD|TRACE|OPTIONS/', $method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "GET|POST|PUT|DELETE|HEAD|TRACE|OPTIONS", "%s" given', var_export($method, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($method) && !is_string($method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($method)), __LINE__);
        }
        $this->method = $method;
        return $this;
    }
    /**
     * Get url value
     * @return string
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \Docdata\StructType\PaymentRedirect
     */
    public function setUrl($url = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($url) && strlen($url) > 2048) || (is_array($url) && count($url) > 2048)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2048 element(s) or a scalar of 2048 character(s) at most, "%d" length given', is_scalar($url) ? strlen($url) : count($url)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($url) && strlen($url) < 1) || (is_array($url) && count($url) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get parameters value
     * @return \Docdata\StructType\Parameters
     */
    public function getParameters()
    {
        return $this->parameters;
    }
    /**
     * Set parameters value
     * @param \Docdata\StructType\Parameters $parameters
     * @return \Docdata\StructType\PaymentRedirect
     */
    public function setParameters(\Docdata\StructType\Parameters $parameters = null)
    {
        $this->parameters = $parameters;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Docdata\StructType\PaymentRedirect::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Docdata\StructType\PaymentRedirect
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\PaymentRedirect
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
