<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for invoice StructType
 * Meta informations extracted from the WSDL
 * - documentation: Optional additional data used for invoices.
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class Invoice extends AbstractStructBase
{
    /**
     * The totalNetAmount
     * Meta informations extracted from the WSDL
     * - documentation: Total net amount for this order.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\Amount
     */
    public $totalNetAmount;
    /**
     * The totalVatAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \Docdata\StructType\TotalVatAmount[]
     */
    public $totalVatAmount;
    /**
     * The item
     * Meta informations extracted from the WSDL
     * - documentation: Information concerning the ordered items.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \Docdata\StructType\Item[]
     */
    public $item;
    /**
     * The shipTo
     * Meta informations extracted from the WSDL
     * - documentation: Name and address to use for shipping.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\Destination
     */
    public $shipTo;
    /**
     * The additionalDescription
     * Meta informations extracted from the WSDL
     * - documentation: Additional description concerning the payment order.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $additionalDescription;
    /**
     * Constructor method for invoice
     * @uses Invoice::setTotalNetAmount()
     * @uses Invoice::setTotalVatAmount()
     * @uses Invoice::setItem()
     * @uses Invoice::setShipTo()
     * @uses Invoice::setAdditionalDescription()
     * @param \Docdata\StructType\Amount $totalNetAmount
     * @param \Docdata\StructType\TotalVatAmount[] $totalVatAmount
     * @param \Docdata\StructType\Item[] $item
     * @param \Docdata\StructType\Destination $shipTo
     * @param string $additionalDescription
     */
    public function __construct(\Docdata\StructType\Amount $totalNetAmount = null, array $totalVatAmount = array(), array $item = array(), \Docdata\StructType\Destination $shipTo = null, $additionalDescription = null)
    {
        $this
            ->setTotalNetAmount($totalNetAmount)
            ->setTotalVatAmount($totalVatAmount)
            ->setItem($item)
            ->setShipTo($shipTo)
            ->setAdditionalDescription($additionalDescription);
    }
    /**
     * Get totalNetAmount value
     * @return \Docdata\StructType\Amount
     */
    public function getTotalNetAmount()
    {
        return $this->totalNetAmount;
    }
    /**
     * Set totalNetAmount value
     * @param \Docdata\StructType\Amount $totalNetAmount
     * @return \Docdata\StructType\Invoice
     */
    public function setTotalNetAmount(\Docdata\StructType\Amount $totalNetAmount = null)
    {
        $this->totalNetAmount = $totalNetAmount;
        return $this;
    }
    /**
     * Get totalVatAmount value
     * @return \Docdata\StructType\TotalVatAmount[]
     */
    public function getTotalVatAmount()
    {
        return $this->totalVatAmount;
    }
    /**
     * Set totalVatAmount value
     * @throws \InvalidArgumentException
     * @param \Docdata\StructType\TotalVatAmount[] $totalVatAmount
     * @return \Docdata\StructType\Invoice
     */
    public function setTotalVatAmount(array $totalVatAmount = array())
    {
        foreach ($totalVatAmount as $invoiceTotalVatAmountItem) {
            // validation for constraint: itemType
            if (!$invoiceTotalVatAmountItem instanceof \Docdata\StructType\TotalVatAmount) {
                throw new \InvalidArgumentException(sprintf('The totalVatAmount property can only contain items of \Docdata\StructType\TotalVatAmount, "%s" given', is_object($invoiceTotalVatAmountItem) ? get_class($invoiceTotalVatAmountItem) : gettype($invoiceTotalVatAmountItem)), __LINE__);
            }
        }
        $this->totalVatAmount = $totalVatAmount;
        return $this;
    }
    /**
     * Add item to totalVatAmount value
     * @throws \InvalidArgumentException
     * @param \Docdata\StructType\TotalVatAmount $item
     * @return \Docdata\StructType\Invoice
     */
    public function addToTotalVatAmount(\Docdata\StructType\TotalVatAmount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Docdata\StructType\TotalVatAmount) {
            throw new \InvalidArgumentException(sprintf('The totalVatAmount property can only contain items of \Docdata\StructType\TotalVatAmount, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->totalVatAmount[] = $item;
        return $this;
    }
    /**
     * Get item value
     * @return \Docdata\StructType\Item[]
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @throws \InvalidArgumentException
     * @param \Docdata\StructType\Item[] $item
     * @return \Docdata\StructType\Invoice
     */
    public function setItem(array $item = array())
    {
        foreach ($item as $invoiceItemItem) {
            // validation for constraint: itemType
            if (!$invoiceItemItem instanceof \Docdata\StructType\Item) {
                throw new \InvalidArgumentException(sprintf('The item property can only contain items of \Docdata\StructType\Item, "%s" given', is_object($invoiceItemItem) ? get_class($invoiceItemItem) : gettype($invoiceItemItem)), __LINE__);
            }
        }
        $this->item = $item;
        return $this;
    }
    /**
     * Add item to item value
     * @throws \InvalidArgumentException
     * @param \Docdata\StructType\Item $item
     * @return \Docdata\StructType\Invoice
     */
    public function addToItem(\Docdata\StructType\Item $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Docdata\StructType\Item) {
            throw new \InvalidArgumentException(sprintf('The item property can only contain items of \Docdata\StructType\Item, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->item[] = $item;
        return $this;
    }
    /**
     * Get shipTo value
     * @return \Docdata\StructType\Destination
     */
    public function getShipTo()
    {
        return $this->shipTo;
    }
    /**
     * Set shipTo value
     * @param \Docdata\StructType\Destination $shipTo
     * @return \Docdata\StructType\Invoice
     */
    public function setShipTo(\Docdata\StructType\Destination $shipTo = null)
    {
        $this->shipTo = $shipTo;
        return $this;
    }
    /**
     * Get additionalDescription value
     * @return string|null
     */
    public function getAdditionalDescription()
    {
        return $this->additionalDescription;
    }
    /**
     * Set additionalDescription value
     * @param string $additionalDescription
     * @return \Docdata\StructType\Invoice
     */
    public function setAdditionalDescription($additionalDescription = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($additionalDescription) && strlen($additionalDescription) > 100) || (is_array($additionalDescription) && count($additionalDescription) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($additionalDescription) ? strlen($additionalDescription) : count($additionalDescription)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($additionalDescription) && strlen($additionalDescription) < 1) || (is_array($additionalDescription) && count($additionalDescription) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($additionalDescription) && !is_string($additionalDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($additionalDescription)), __LINE__);
        }
        $this->additionalDescription = $additionalDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\Invoice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
