<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for extendedStatusResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: Response to a extended status request.
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class ExtendedStatusResponse extends AbstractStructBase
{
    /**
     * The statusErrors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\StatusErrors
     */
    public $statusErrors;
    /**
     * The statusSuccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\StatusSuccess
     */
    public $statusSuccess;
    /**
     * The ddpXsdVersion
     * Meta informations extracted from the WSDL
     * - use: required
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $ddpXsdVersion;
    /**
     * Constructor method for extendedStatusResponse
     * @uses ExtendedStatusResponse::setStatusErrors()
     * @uses ExtendedStatusResponse::setStatusSuccess()
     * @uses ExtendedStatusResponse::setDdpXsdVersion()
     * @param \Docdata\StructType\StatusErrors $statusErrors
     * @param \Docdata\StructType\StatusSuccess $statusSuccess
     * @param string $ddpXsdVersion
     */
    public function __construct(\Docdata\StructType\StatusErrors $statusErrors = null, \Docdata\StructType\StatusSuccess $statusSuccess = null, $ddpXsdVersion = null)
    {
        $this
            ->setStatusErrors($statusErrors)
            ->setStatusSuccess($statusSuccess)
            ->setDdpXsdVersion($ddpXsdVersion);
    }
    /**
     * Get statusErrors value
     * @return \Docdata\StructType\StatusErrors
     */
    public function getStatusErrors()
    {
        return $this->statusErrors;
    }
    /**
     * Set statusErrors value
     * @param \Docdata\StructType\StatusErrors $statusErrors
     * @return \Docdata\StructType\ExtendedStatusResponse
     */
    public function setStatusErrors(\Docdata\StructType\StatusErrors $statusErrors = null)
    {
        $this->statusErrors = $statusErrors;
        return $this;
    }
    /**
     * Get statusSuccess value
     * @return \Docdata\StructType\StatusSuccess
     */
    public function getStatusSuccess()
    {
        return $this->statusSuccess;
    }
    /**
     * Set statusSuccess value
     * @param \Docdata\StructType\StatusSuccess $statusSuccess
     * @return \Docdata\StructType\ExtendedStatusResponse
     */
    public function setStatusSuccess(\Docdata\StructType\StatusSuccess $statusSuccess = null)
    {
        $this->statusSuccess = $statusSuccess;
        return $this;
    }
    /**
     * Get ddpXsdVersion value
     * @return string
     */
    public function getDdpXsdVersion()
    {
        return $this->ddpXsdVersion;
    }
    /**
     * Set ddpXsdVersion value
     * @param string $ddpXsdVersion
     * @return \Docdata\StructType\ExtendedStatusResponse
     */
    public function setDdpXsdVersion($ddpXsdVersion = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ddpXsdVersion) && strlen($ddpXsdVersion) > 35) || (is_array($ddpXsdVersion) && count($ddpXsdVersion) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($ddpXsdVersion) ? strlen($ddpXsdVersion) : count($ddpXsdVersion)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($ddpXsdVersion) && strlen($ddpXsdVersion) < 1) || (is_array($ddpXsdVersion) && count($ddpXsdVersion) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ddpXsdVersion) && !is_string($ddpXsdVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ddpXsdVersion)), __LINE__);
        }
        $this->ddpXsdVersion = $ddpXsdVersion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\ExtendedStatusResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
