<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for elvPaymentInput StructType
 * Meta informations extracted from the WSDL
 * - documentation: ELV payment input.
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class ElvPaymentInput extends AbstractStructBase
{
    /**
     * The accountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $accountNumber;
    /**
     * The bankCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $bankCode;
    /**
     * The iban
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $iban;
    /**
     * Constructor method for elvPaymentInput
     * @uses ElvPaymentInput::setAccountNumber()
     * @uses ElvPaymentInput::setBankCode()
     * @uses ElvPaymentInput::setIban()
     * @param string $accountNumber
     * @param string $bankCode
     * @param string $iban
     */
    public function __construct($accountNumber = null, $bankCode = null, $iban = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setBankCode($bankCode)
            ->setIban($iban);
    }
    /**
     * Get accountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->accountNumber;
    }
    /**
     * Set accountNumber value
     * @param string $accountNumber
     * @return \Docdata\StructType\ElvPaymentInput
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($accountNumber) && strlen($accountNumber) > 35) || (is_array($accountNumber) && count($accountNumber) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($accountNumber) ? strlen($accountNumber) : count($accountNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($accountNumber) && strlen($accountNumber) < 1) || (is_array($accountNumber) && count($accountNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->accountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get bankCode value
     * @return string|null
     */
    public function getBankCode()
    {
        return $this->bankCode;
    }
    /**
     * Set bankCode value
     * @param string $bankCode
     * @return \Docdata\StructType\ElvPaymentInput
     */
    public function setBankCode($bankCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bankCode) && strlen($bankCode) > 35) || (is_array($bankCode) && count($bankCode) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($bankCode) ? strlen($bankCode) : count($bankCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($bankCode) && strlen($bankCode) < 1) || (is_array($bankCode) && count($bankCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bankCode) && !is_string($bankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankCode)), __LINE__);
        }
        $this->bankCode = $bankCode;
        return $this;
    }
    /**
     * Get iban value
     * @return string|null
     */
    public function getIban()
    {
        return $this->iban;
    }
    /**
     * Set iban value
     * @param string $iban
     * @return \Docdata\StructType\ElvPaymentInput
     */
    public function setIban($iban = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iban) && strlen($iban) > 35) || (is_array($iban) && count($iban) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($iban) ? strlen($iban) : count($iban)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iban) && strlen($iban) < 1) || (is_array($iban) && count($iban) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iban) && !is_string($iban)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iban)), __LINE__);
        }
        $this->iban = $iban;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\ElvPaymentInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
