<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for customer StructType
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
abstract class Customer extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - use: required
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $id;
    /**
     * The idsShopperKey
     * Meta informations extracted from the WSDL
     * - documentation: The key of the customer as it is known Identity Service. The key is required when using payment methods that require a mandate to be created and maintained by Identity Service. For example, the payment method SEPA in combination with
     * a Sentenial mandate requires a Shopper Key. The shopper key can be obtained via Identity Service. | A UUID type 4 token, which is compliant with RFC-4122 and ITU-T Rec. X.667. See also
     * https://en.wikipedia.org/wiki/Universally_unique_identifier#Definition
     * - use: optional
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-4[0-9a-fA-F]{3}-[89aAbB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}
     * @var string
     */
    public $idsShopperKey;
    /**
     * Constructor method for customer
     * @uses Customer::setId()
     * @uses Customer::setIdsShopperKey()
     * @param string $id
     * @param string $idsShopperKey
     */
    public function __construct($id = null, $idsShopperKey = null)
    {
        $this
            ->setId($id)
            ->setIdsShopperKey($idsShopperKey);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \Docdata\StructType\Customer
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 50) || (is_array($id) && count($id) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get idsShopperKey value
     * @return string|null
     */
    public function getIdsShopperKey()
    {
        return $this->idsShopperKey;
    }
    /**
     * Set idsShopperKey value
     * @param string $idsShopperKey
     * @return \Docdata\StructType\Customer
     */
    public function setIdsShopperKey($idsShopperKey = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idsShopperKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-4[0-9a-fA-F]{3}-[89aAbB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}/', $idsShopperKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-4[0-9a-fA-F]{3}-[89aAbB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}", "%s" given', var_export($idsShopperKey, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idsShopperKey) && !is_string($idsShopperKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idsShopperKey)), __LINE__);
        }
        $this->idsShopperKey = $idsShopperKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\Customer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
