<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for consideredSafe StructType
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class ConsideredSafe extends AbstractStructBase
{
    /**
     * The value
     * Meta informations extracted from the WSDL
     * - documentation: True when the order is considered safe based on the considered safe profile.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $value;
    /**
     * The level
     * Meta informations extracted from the WSDL
     * - documentation: The considered safe level, e.g. SAFEST, SAFE, FAST or FASTEST.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $level;
    /**
     * The date
     * Meta informations extracted from the WSDL
     * - documentation: The date when the order became considered safe. Only filled when the value is true.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $date;
    /**
     * The reason
     * Meta informations extracted from the WSDL
     * - documentation: The reason for the modification of the considered safe state.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reason;
    /**
     * The modifiedUser
     * Meta informations extracted from the WSDL
     * - documentation: The user which has made the change when modifiedType equals MANUAL.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $modifiedUser;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for consideredSafe
     * @uses ConsideredSafe::setValue()
     * @uses ConsideredSafe::setLevel()
     * @uses ConsideredSafe::setDate()
     * @uses ConsideredSafe::setReason()
     * @uses ConsideredSafe::setModifiedUser()
     * @uses ConsideredSafe::setAny()
     * @param bool $value
     * @param string $level
     * @param string $date
     * @param string $reason
     * @param string $modifiedUser
     * @param \DOMDocument $any
     */
    public function __construct($value = null, $level = null, $date = null, $reason = null, $modifiedUser = null, \DOMDocument $any = null)
    {
        $this
            ->setValue($value)
            ->setLevel($level)
            ->setDate($date)
            ->setReason($reason)
            ->setModifiedUser($modifiedUser)
            ->setAny($any);
    }
    /**
     * Get value value
     * @return bool
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param bool $value
     * @return \Docdata\StructType\ConsideredSafe
     */
    public function setValue($value = null)
    {
        $this->value = $value;
        return $this;
    }
    /**
     * Get level value
     * @return string
     */
    public function getLevel()
    {
        return $this->level;
    }
    /**
     * Set level value
     * @param string $level
     * @return \Docdata\StructType\ConsideredSafe
     */
    public function setLevel($level = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($level) && strlen($level) > 35) || (is_array($level) && count($level) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($level) ? strlen($level) : count($level)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($level) && strlen($level) < 1) || (is_array($level) && count($level) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($level) && !is_string($level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($level)), __LINE__);
        }
        $this->level = $level;
        return $this;
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \Docdata\StructType\ConsideredSafe
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * Set reason value
     * @uses \Docdata\EnumType\Reason::valueIsValid()
     * @uses \Docdata\EnumType\Reason::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reason
     * @return \Docdata\StructType\ConsideredSafe
     */
    public function setReason($reason = null)
    {
        // validation for constraint: enumeration
        if (!\Docdata\EnumType\Reason::valueIsValid($reason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $reason, implode(', ', \Docdata\EnumType\Reason::getValidValues())), __LINE__);
        }
        $this->reason = $reason;
        return $this;
    }
    /**
     * Get modifiedUser value
     * @return string|null
     */
    public function getModifiedUser()
    {
        return $this->modifiedUser;
    }
    /**
     * Set modifiedUser value
     * @param string $modifiedUser
     * @return \Docdata\StructType\ConsideredSafe
     */
    public function setModifiedUser($modifiedUser = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($modifiedUser) && strlen($modifiedUser) > 50) || (is_array($modifiedUser) && count($modifiedUser) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($modifiedUser) ? strlen($modifiedUser) : count($modifiedUser)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($modifiedUser) && strlen($modifiedUser) < 1) || (is_array($modifiedUser) && count($modifiedUser) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($modifiedUser) && !is_string($modifiedUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modifiedUser)), __LINE__);
        }
        $this->modifiedUser = $modifiedUser;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Docdata\StructType\ConsideredSafe::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Docdata\StructType\ConsideredSafe
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\ConsideredSafe
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
