<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for chargeback StructType
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class Chargeback extends AbstractStructBase
{
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $status;
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\Amount
     */
    public $amount;
    /**
     * The chargebackId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $chargebackId;
    /**
     * The reason
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 250
     * - minLength: 1
     * @var string
     */
    public $reason;
    /**
     * The enquiryReason
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 250
     * - minLength: 1
     * @var string
     */
    public $enquiryReason;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for chargeback
     * @uses Chargeback::setStatus()
     * @uses Chargeback::setAmount()
     * @uses Chargeback::setChargebackId()
     * @uses Chargeback::setReason()
     * @uses Chargeback::setEnquiryReason()
     * @uses Chargeback::setAny()
     * @param string $status
     * @param \Docdata\StructType\Amount $amount
     * @param string $chargebackId
     * @param string $reason
     * @param string $enquiryReason
     * @param \DOMDocument $any
     */
    public function __construct($status = null, \Docdata\StructType\Amount $amount = null, $chargebackId = null, $reason = null, $enquiryReason = null, \DOMDocument $any = null)
    {
        $this
            ->setStatus($status)
            ->setAmount($amount)
            ->setChargebackId($chargebackId)
            ->setReason($reason)
            ->setEnquiryReason($enquiryReason)
            ->setAny($any);
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \Docdata\StructType\Chargeback
     */
    public function setStatus($status = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($status) && strlen($status) > 35) || (is_array($status) && count($status) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($status) ? strlen($status) : count($status)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($status) && strlen($status) < 1) || (is_array($status) && count($status) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get amount value
     * @return \Docdata\StructType\Amount
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param \Docdata\StructType\Amount $amount
     * @return \Docdata\StructType\Chargeback
     */
    public function setAmount(\Docdata\StructType\Amount $amount = null)
    {
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get chargebackId value
     * @return string|null
     */
    public function getChargebackId()
    {
        return $this->chargebackId;
    }
    /**
     * Set chargebackId value
     * @param string $chargebackId
     * @return \Docdata\StructType\Chargeback
     */
    public function setChargebackId($chargebackId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($chargebackId) && strlen($chargebackId) > 35) || (is_array($chargebackId) && count($chargebackId) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($chargebackId) ? strlen($chargebackId) : count($chargebackId)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($chargebackId) && strlen($chargebackId) < 1) || (is_array($chargebackId) && count($chargebackId) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($chargebackId) && !is_string($chargebackId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargebackId)), __LINE__);
        }
        $this->chargebackId = $chargebackId;
        return $this;
    }
    /**
     * Get reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * Set reason value
     * @param string $reason
     * @return \Docdata\StructType\Chargeback
     */
    public function setReason($reason = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($reason) && strlen($reason) > 250) || (is_array($reason) && count($reason) > 250)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 250 element(s) or a scalar of 250 character(s) at most, "%d" length given', is_scalar($reason) ? strlen($reason) : count($reason)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($reason) && strlen($reason) < 1) || (is_array($reason) && count($reason) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reason)), __LINE__);
        }
        $this->reason = $reason;
        return $this;
    }
    /**
     * Get enquiryReason value
     * @return string|null
     */
    public function getEnquiryReason()
    {
        return $this->enquiryReason;
    }
    /**
     * Set enquiryReason value
     * @param string $enquiryReason
     * @return \Docdata\StructType\Chargeback
     */
    public function setEnquiryReason($enquiryReason = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($enquiryReason) && strlen($enquiryReason) > 250) || (is_array($enquiryReason) && count($enquiryReason) > 250)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 250 element(s) or a scalar of 250 character(s) at most, "%d" length given', is_scalar($enquiryReason) ? strlen($enquiryReason) : count($enquiryReason)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($enquiryReason) && strlen($enquiryReason) < 1) || (is_array($enquiryReason) && count($enquiryReason) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enquiryReason) && !is_string($enquiryReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enquiryReason)), __LINE__);
        }
        $this->enquiryReason = $enquiryReason;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Docdata\StructType\Chargeback::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Docdata\StructType\Chargeback
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\Chargeback
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
