<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cardPaymentInput StructType
 * Meta informations extracted from the WSDL
 * - documentation: Generic credit or debit card payment input. This can be either: 1. A card number and an expiry date 2. A base64 encoded string containing the encrypted card details and the key alias
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class CardPaymentInput extends AbstractStructBase
{
    /**
     * The cardHolderName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $cardHolderName;
    /**
     * The cardNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: Debit- or credit card number.
     * - pattern: [0-9]{13,19}
     * @var string
     */
    public $cardNumber;
    /**
     * The expiryDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\ExpiryDate
     */
    public $expiryDate;
    /**
     * The encryptedData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $encryptedData;
    /**
     * The securityCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: 3 or 4 digit security code (cvc2, cid, cvv2).
     * - pattern: [0-9]{3,4}
     * @var string
     */
    public $securityCode;
    /**
     * Constructor method for cardPaymentInput
     * @uses CardPaymentInput::setCardHolderName()
     * @uses CardPaymentInput::setCardNumber()
     * @uses CardPaymentInput::setExpiryDate()
     * @uses CardPaymentInput::setEncryptedData()
     * @uses CardPaymentInput::setSecurityCode()
     * @param string $cardHolderName
     * @param string $cardNumber
     * @param \Docdata\StructType\ExpiryDate $expiryDate
     * @param string $encryptedData
     * @param string $securityCode
     */
    public function __construct($cardHolderName = null, $cardNumber = null, \Docdata\StructType\ExpiryDate $expiryDate = null, $encryptedData = null, $securityCode = null)
    {
        $this
            ->setCardHolderName($cardHolderName)
            ->setCardNumber($cardNumber)
            ->setExpiryDate($expiryDate)
            ->setEncryptedData($encryptedData)
            ->setSecurityCode($securityCode);
    }
    /**
     * Get cardHolderName value
     * @return string
     */
    public function getCardHolderName()
    {
        return $this->cardHolderName;
    }
    /**
     * Set cardHolderName value
     * @param string $cardHolderName
     * @return \Docdata\StructType\CardPaymentInput
     */
    public function setCardHolderName($cardHolderName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cardHolderName) && strlen($cardHolderName) > 35) || (is_array($cardHolderName) && count($cardHolderName) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($cardHolderName) ? strlen($cardHolderName) : count($cardHolderName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($cardHolderName) && strlen($cardHolderName) < 1) || (is_array($cardHolderName) && count($cardHolderName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cardHolderName) && !is_string($cardHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardHolderName)), __LINE__);
        }
        $this->cardHolderName = $cardHolderName;
        return $this;
    }
    /**
     * Get cardNumber value
     * @return string
     */
    public function getCardNumber()
    {
        return $this->cardNumber;
    }
    /**
     * Set cardNumber value
     * @param string $cardNumber
     * @return \Docdata\StructType\CardPaymentInput
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: pattern
        if (is_scalar($cardNumber) && !preg_match('/[0-9]{13,19}/', $cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{13,19}", "%s" given', var_export($cardNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardNumber)), __LINE__);
        }
        $this->cardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get expiryDate value
     * @return \Docdata\StructType\ExpiryDate
     */
    public function getExpiryDate()
    {
        return $this->expiryDate;
    }
    /**
     * Set expiryDate value
     * @param \Docdata\StructType\ExpiryDate $expiryDate
     * @return \Docdata\StructType\CardPaymentInput
     */
    public function setExpiryDate(\Docdata\StructType\ExpiryDate $expiryDate = null)
    {
        $this->expiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get encryptedData value
     * @return string
     */
    public function getEncryptedData()
    {
        return $this->encryptedData;
    }
    /**
     * Set encryptedData value
     * @param string $encryptedData
     * @return \Docdata\StructType\CardPaymentInput
     */
    public function setEncryptedData($encryptedData = null)
    {
        // validation for constraint: string
        if (!is_null($encryptedData) && !is_string($encryptedData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($encryptedData)), __LINE__);
        }
        $this->encryptedData = $encryptedData;
        return $this;
    }
    /**
     * Get securityCode value
     * @return string|null
     */
    public function getSecurityCode()
    {
        return $this->securityCode;
    }
    /**
     * Set securityCode value
     * @param string $securityCode
     * @return \Docdata\StructType\CardPaymentInput
     */
    public function setSecurityCode($securityCode = null)
    {
        // validation for constraint: pattern
        if (is_scalar($securityCode) && !preg_match('/[0-9]{3,4}/', $securityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{3,4}", "%s" given', var_export($securityCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($securityCode) && !is_string($securityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($securityCode)), __LINE__);
        }
        $this->securityCode = $securityCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\CardPaymentInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
