<?php

namespace Docdata\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Start ServiceType
 * @subpackage Services
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class Start extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named start
     * Meta informations extracted from the WSDL
     * - documentation: Starts processing of a payment order in the DocData system. This is an alternative to using the web menu hosted payment pages. When an initial (previous) payment order is specified, the details will be reused from that payment order.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Docdata\StructType\StartRequest $parameters
     * @return \Docdata\StructType\StartResponse|bool
     */
    public function start(\Docdata\StructType\StartRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->start($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Docdata\StructType\StartResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
