<?php

namespace Docdata\EnumType;

/**
 * This class stands for errorCode EnumType
 * Meta informations extracted from the WSDL
 * - documentation: The error code of the error. The reason of error is unknown. Request data is missing. Request data is incorrect. Error related to security violations such as login failure or not allowed IP. Payment system error.
 * @subpackage Enumerations
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class ErrorCode
{
    /**
     * Constant for value 'UNKNOWN_ERROR'
     * @return string 'UNKNOWN_ERROR'
     */
    const VALUE_UNKNOWN_ERROR = 'UNKNOWN_ERROR';
    /**
     * Constant for value 'REQUEST_DATA_MISSING'
     * @return string 'REQUEST_DATA_MISSING'
     */
    const VALUE_REQUEST_DATA_MISSING = 'REQUEST_DATA_MISSING';
    /**
     * Constant for value 'REQUEST_DATA_INCORRECT'
     * @return string 'REQUEST_DATA_INCORRECT'
     */
    const VALUE_REQUEST_DATA_INCORRECT = 'REQUEST_DATA_INCORRECT';
    /**
     * Constant for value 'SECURITY_ERROR'
     * @return string 'SECURITY_ERROR'
     */
    const VALUE_SECURITY_ERROR = 'SECURITY_ERROR';
    /**
     * Constant for value 'INTERNAL_ERROR'
     * @return string 'INTERNAL_ERROR'
     */
    const VALUE_INTERNAL_ERROR = 'INTERNAL_ERROR';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN_ERROR
     * @uses self::VALUE_REQUEST_DATA_MISSING
     * @uses self::VALUE_REQUEST_DATA_INCORRECT
     * @uses self::VALUE_SECURITY_ERROR
     * @uses self::VALUE_INTERNAL_ERROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN_ERROR,
            self::VALUE_REQUEST_DATA_MISSING,
            self::VALUE_REQUEST_DATA_INCORRECT,
            self::VALUE_SECURITY_ERROR,
            self::VALUE_INTERNAL_ERROR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
