<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for technicalIntegrationInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: This element contains information about the application contacting the webservice. This info is useful when debugging troubleshooting technical integration issues.
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class TechnicalIntegrationInfo extends AbstractStructBase
{
    /**
     * The webshopPlugin
     * Meta informations extracted from the WSDL
     * - documentation: The name of the plugin used to contact this webservice.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $webshopPlugin;
    /**
     * The webshopPluginVersion
     * Meta informations extracted from the WSDL
     * - documentation: The version of the plugin used to contact this webservice.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $webshopPluginVersion;
    /**
     * The integratorName
     * Meta informations extracted from the WSDL
     * - documentation: The name of the plugin creator used to contact this webservice.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $integratorName;
    /**
     * The programmingLanguage
     * Meta informations extracted from the WSDL
     * - documentation: The programming language used to contact this webservice.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $programmingLanguage;
    /**
     * The operatingSystem
     * Meta informations extracted from the WSDL
     * - documentation: The operating system from which this webservice is contacted.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $operatingSystem;
    /**
     * The operatingSystemVersion
     * Meta informations extracted from the WSDL
     * - documentation: The version number of the operating system from which this webservice is contacted.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $operatingSystemVersion;
    /**
     * The ddpXsdVersion
     * Meta informations extracted from the WSDL
     * - documentation: The full version number (including minor e.q. 1.3.0) of the xsd which is used during integration. DDP can make minor (non-breaking) changes to the xsd. These are reflected in a minor version number. It can therefore be useful to know
     * if a different minor version of the xsd was used during merchant development than the one currently active in production.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $ddpXsdVersion;
    /**
     * Constructor method for technicalIntegrationInfo
     * @uses TechnicalIntegrationInfo::setWebshopPlugin()
     * @uses TechnicalIntegrationInfo::setWebshopPluginVersion()
     * @uses TechnicalIntegrationInfo::setIntegratorName()
     * @uses TechnicalIntegrationInfo::setProgrammingLanguage()
     * @uses TechnicalIntegrationInfo::setOperatingSystem()
     * @uses TechnicalIntegrationInfo::setOperatingSystemVersion()
     * @uses TechnicalIntegrationInfo::setDdpXsdVersion()
     * @param string $webshopPlugin
     * @param string $webshopPluginVersion
     * @param string $integratorName
     * @param string $programmingLanguage
     * @param string $operatingSystem
     * @param string $operatingSystemVersion
     * @param string $ddpXsdVersion
     */
    public function __construct($webshopPlugin = null, $webshopPluginVersion = null, $integratorName = null, $programmingLanguage = null, $operatingSystem = null, $operatingSystemVersion = null, $ddpXsdVersion = null)
    {
        $this
            ->setWebshopPlugin($webshopPlugin)
            ->setWebshopPluginVersion($webshopPluginVersion)
            ->setIntegratorName($integratorName)
            ->setProgrammingLanguage($programmingLanguage)
            ->setOperatingSystem($operatingSystem)
            ->setOperatingSystemVersion($operatingSystemVersion)
            ->setDdpXsdVersion($ddpXsdVersion);
    }
    /**
     * Get webshopPlugin value
     * @return string|null
     */
    public function getWebshopPlugin()
    {
        return $this->webshopPlugin;
    }
    /**
     * Set webshopPlugin value
     * @param string $webshopPlugin
     * @return \Docdata\StructType\TechnicalIntegrationInfo
     */
    public function setWebshopPlugin($webshopPlugin = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($webshopPlugin) && strlen($webshopPlugin) > 35) || (is_array($webshopPlugin) && count($webshopPlugin) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($webshopPlugin) ? strlen($webshopPlugin) : count($webshopPlugin)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($webshopPlugin) && strlen($webshopPlugin) < 1) || (is_array($webshopPlugin) && count($webshopPlugin) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($webshopPlugin) && !is_string($webshopPlugin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($webshopPlugin)), __LINE__);
        }
        $this->webshopPlugin = $webshopPlugin;
        return $this;
    }
    /**
     * Get webshopPluginVersion value
     * @return string|null
     */
    public function getWebshopPluginVersion()
    {
        return $this->webshopPluginVersion;
    }
    /**
     * Set webshopPluginVersion value
     * @param string $webshopPluginVersion
     * @return \Docdata\StructType\TechnicalIntegrationInfo
     */
    public function setWebshopPluginVersion($webshopPluginVersion = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($webshopPluginVersion) && strlen($webshopPluginVersion) > 35) || (is_array($webshopPluginVersion) && count($webshopPluginVersion) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($webshopPluginVersion) ? strlen($webshopPluginVersion) : count($webshopPluginVersion)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($webshopPluginVersion) && strlen($webshopPluginVersion) < 1) || (is_array($webshopPluginVersion) && count($webshopPluginVersion) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($webshopPluginVersion) && !is_string($webshopPluginVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($webshopPluginVersion)), __LINE__);
        }
        $this->webshopPluginVersion = $webshopPluginVersion;
        return $this;
    }
    /**
     * Get integratorName value
     * @return string|null
     */
    public function getIntegratorName()
    {
        return $this->integratorName;
    }
    /**
     * Set integratorName value
     * @param string $integratorName
     * @return \Docdata\StructType\TechnicalIntegrationInfo
     */
    public function setIntegratorName($integratorName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($integratorName) && strlen($integratorName) > 35) || (is_array($integratorName) && count($integratorName) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($integratorName) ? strlen($integratorName) : count($integratorName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($integratorName) && strlen($integratorName) < 1) || (is_array($integratorName) && count($integratorName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($integratorName) && !is_string($integratorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($integratorName)), __LINE__);
        }
        $this->integratorName = $integratorName;
        return $this;
    }
    /**
     * Get programmingLanguage value
     * @return string|null
     */
    public function getProgrammingLanguage()
    {
        return $this->programmingLanguage;
    }
    /**
     * Set programmingLanguage value
     * @param string $programmingLanguage
     * @return \Docdata\StructType\TechnicalIntegrationInfo
     */
    public function setProgrammingLanguage($programmingLanguage = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($programmingLanguage) && strlen($programmingLanguage) > 35) || (is_array($programmingLanguage) && count($programmingLanguage) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($programmingLanguage) ? strlen($programmingLanguage) : count($programmingLanguage)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($programmingLanguage) && strlen($programmingLanguage) < 1) || (is_array($programmingLanguage) && count($programmingLanguage) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($programmingLanguage) && !is_string($programmingLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($programmingLanguage)), __LINE__);
        }
        $this->programmingLanguage = $programmingLanguage;
        return $this;
    }
    /**
     * Get operatingSystem value
     * @return string|null
     */
    public function getOperatingSystem()
    {
        return $this->operatingSystem;
    }
    /**
     * Set operatingSystem value
     * @param string $operatingSystem
     * @return \Docdata\StructType\TechnicalIntegrationInfo
     */
    public function setOperatingSystem($operatingSystem = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($operatingSystem) && strlen($operatingSystem) > 35) || (is_array($operatingSystem) && count($operatingSystem) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($operatingSystem) ? strlen($operatingSystem) : count($operatingSystem)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($operatingSystem) && strlen($operatingSystem) < 1) || (is_array($operatingSystem) && count($operatingSystem) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($operatingSystem) && !is_string($operatingSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operatingSystem)), __LINE__);
        }
        $this->operatingSystem = $operatingSystem;
        return $this;
    }
    /**
     * Get operatingSystemVersion value
     * @return string|null
     */
    public function getOperatingSystemVersion()
    {
        return $this->operatingSystemVersion;
    }
    /**
     * Set operatingSystemVersion value
     * @param string $operatingSystemVersion
     * @return \Docdata\StructType\TechnicalIntegrationInfo
     */
    public function setOperatingSystemVersion($operatingSystemVersion = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($operatingSystemVersion) && strlen($operatingSystemVersion) > 35) || (is_array($operatingSystemVersion) && count($operatingSystemVersion) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($operatingSystemVersion) ? strlen($operatingSystemVersion) : count($operatingSystemVersion)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($operatingSystemVersion) && strlen($operatingSystemVersion) < 1) || (is_array($operatingSystemVersion) && count($operatingSystemVersion) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($operatingSystemVersion) && !is_string($operatingSystemVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operatingSystemVersion)), __LINE__);
        }
        $this->operatingSystemVersion = $operatingSystemVersion;
        return $this;
    }
    /**
     * Get ddpXsdVersion value
     * @return string|null
     */
    public function getDdpXsdVersion()
    {
        return $this->ddpXsdVersion;
    }
    /**
     * Set ddpXsdVersion value
     * @param string $ddpXsdVersion
     * @return \Docdata\StructType\TechnicalIntegrationInfo
     */
    public function setDdpXsdVersion($ddpXsdVersion = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ddpXsdVersion) && strlen($ddpXsdVersion) > 35) || (is_array($ddpXsdVersion) && count($ddpXsdVersion) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($ddpXsdVersion) ? strlen($ddpXsdVersion) : count($ddpXsdVersion)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($ddpXsdVersion) && strlen($ddpXsdVersion) < 1) || (is_array($ddpXsdVersion) && count($ddpXsdVersion) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ddpXsdVersion) && !is_string($ddpXsdVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ddpXsdVersion)), __LINE__);
        }
        $this->ddpXsdVersion = $ddpXsdVersion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\TechnicalIntegrationInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
