<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shopperInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Shopper information needed by 3DS.
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class ShopperInfo extends AbstractStructBase
{
    /**
     * The shopperIp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 250
     * - minLength: 1
     * @var string
     */
    public $shopperIp;
    /**
     * The browserAccept
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 250
     * - minLength: 1
     * @var string
     */
    public $browserAccept;
    /**
     * The browserUserAgent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 250
     * - minLength: 1
     * @var string
     */
    public $browserUserAgent;
    /**
     * Constructor method for shopperInfo
     * @uses ShopperInfo::setShopperIp()
     * @uses ShopperInfo::setBrowserAccept()
     * @uses ShopperInfo::setBrowserUserAgent()
     * @param string $shopperIp
     * @param string $browserAccept
     * @param string $browserUserAgent
     */
    public function __construct($shopperIp = null, $browserAccept = null, $browserUserAgent = null)
    {
        $this
            ->setShopperIp($shopperIp)
            ->setBrowserAccept($browserAccept)
            ->setBrowserUserAgent($browserUserAgent);
    }
    /**
     * Get shopperIp value
     * @return string
     */
    public function getShopperIp()
    {
        return $this->shopperIp;
    }
    /**
     * Set shopperIp value
     * @param string $shopperIp
     * @return \Docdata\StructType\ShopperInfo
     */
    public function setShopperIp($shopperIp = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($shopperIp) && strlen($shopperIp) > 250) || (is_array($shopperIp) && count($shopperIp) > 250)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 250 element(s) or a scalar of 250 character(s) at most, "%d" length given', is_scalar($shopperIp) ? strlen($shopperIp) : count($shopperIp)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($shopperIp) && strlen($shopperIp) < 1) || (is_array($shopperIp) && count($shopperIp) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($shopperIp) && !is_string($shopperIp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shopperIp)), __LINE__);
        }
        $this->shopperIp = $shopperIp;
        return $this;
    }
    /**
     * Get browserAccept value
     * @return string
     */
    public function getBrowserAccept()
    {
        return $this->browserAccept;
    }
    /**
     * Set browserAccept value
     * @param string $browserAccept
     * @return \Docdata\StructType\ShopperInfo
     */
    public function setBrowserAccept($browserAccept = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($browserAccept) && strlen($browserAccept) > 250) || (is_array($browserAccept) && count($browserAccept) > 250)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 250 element(s) or a scalar of 250 character(s) at most, "%d" length given', is_scalar($browserAccept) ? strlen($browserAccept) : count($browserAccept)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($browserAccept) && strlen($browserAccept) < 1) || (is_array($browserAccept) && count($browserAccept) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($browserAccept) && !is_string($browserAccept)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($browserAccept)), __LINE__);
        }
        $this->browserAccept = $browserAccept;
        return $this;
    }
    /**
     * Get browserUserAgent value
     * @return string
     */
    public function getBrowserUserAgent()
    {
        return $this->browserUserAgent;
    }
    /**
     * Set browserUserAgent value
     * @param string $browserUserAgent
     * @return \Docdata\StructType\ShopperInfo
     */
    public function setBrowserUserAgent($browserUserAgent = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($browserUserAgent) && strlen($browserUserAgent) > 250) || (is_array($browserUserAgent) && count($browserUserAgent) > 250)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 250 element(s) or a scalar of 250 character(s) at most, "%d" length given', is_scalar($browserUserAgent) ? strlen($browserUserAgent) : count($browserUserAgent)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($browserUserAgent) && strlen($browserUserAgent) < 1) || (is_array($browserUserAgent) && count($browserUserAgent) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($browserUserAgent) && !is_string($browserUserAgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($browserUserAgent)), __LINE__);
        }
        $this->browserUserAgent = $browserUserAgent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\ShopperInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
