<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for riskCheck StructType
 * Meta informations extracted from the WSDL
 * - documentation: The sum of all risk checks. The higher the score, the higher the risk. Scores of 100 or above are canceled automatically.
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class RiskCheck extends AbstractStructBase
{
    /**
     * The score
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $score;
    /**
     * The check
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Docdata\StructType\Check[]
     */
    public $check;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for riskCheck
     * @uses RiskCheck::setScore()
     * @uses RiskCheck::setCheck()
     * @uses RiskCheck::setAny()
     * @param int $score
     * @param \Docdata\StructType\Check[] $check
     * @param \DOMDocument $any
     */
    public function __construct($score = null, array $check = array(), \DOMDocument $any = null)
    {
        $this
            ->setScore($score)
            ->setCheck($check)
            ->setAny($any);
    }
    /**
     * Get score value
     * @return int
     */
    public function getScore()
    {
        return $this->score;
    }
    /**
     * Set score value
     * @param int $score
     * @return \Docdata\StructType\RiskCheck
     */
    public function setScore($score = null)
    {
        // validation for constraint: int
        if (!is_null($score) && !is_numeric($score)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($score)), __LINE__);
        }
        $this->score = $score;
        return $this;
    }
    /**
     * Get check value
     * @return \Docdata\StructType\Check[]|null
     */
    public function getCheck()
    {
        return $this->check;
    }
    /**
     * Set check value
     * @throws \InvalidArgumentException
     * @param \Docdata\StructType\Check[] $check
     * @return \Docdata\StructType\RiskCheck
     */
    public function setCheck(array $check = array())
    {
        foreach ($check as $riskCheckCheckItem) {
            // validation for constraint: itemType
            if (!$riskCheckCheckItem instanceof \Docdata\StructType\Check) {
                throw new \InvalidArgumentException(sprintf('The check property can only contain items of \Docdata\StructType\Check, "%s" given', is_object($riskCheckCheckItem) ? get_class($riskCheckCheckItem) : gettype($riskCheckCheckItem)), __LINE__);
            }
        }
        $this->check = $check;
        return $this;
    }
    /**
     * Add item to check value
     * @throws \InvalidArgumentException
     * @param \Docdata\StructType\Check $item
     * @return \Docdata\StructType\RiskCheck
     */
    public function addToCheck(\Docdata\StructType\Check $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Docdata\StructType\Check) {
            throw new \InvalidArgumentException(sprintf('The check property can only contain items of \Docdata\StructType\Check, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->check[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Docdata\StructType\RiskCheck::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Docdata\StructType\RiskCheck
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\RiskCheck
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
