<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for refundRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Allows to request a full or partial refund. | Either a simple a refund or a detailed refund.
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class RefundRequest extends AbstractStructBase
{
    /**
     * The merchant
     * Meta informations extracted from the WSDL
     * - documentation: Merchant's credentials.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\Merchant
     */
    public $merchant;
    /**
     * The paymentId
     * Meta informations extracted from the WSDL
     * - documentation: The payment ID on which the refund request needs to be performed. Can be retrieved from the status report. | The payment ID with check digit as generated by the payment system.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $paymentId;
    /**
     * The refundItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\RefundItems
     */
    public $refundItems;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - fixed: 1.3
     * - use: required
     * @var float
     */
    public $version;
    /**
     * The merchantRefundReference
     * Meta informations extracted from the WSDL
     * - documentation: Merchant's internal ID for identifying this refund.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $merchantRefundReference;
    /**
     * The amount
     * @var \Docdata\StructType\Amount
     */
    public $amount;
    /**
     * The itemCode
     * Meta informations extracted from the WSDL
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $itemCode;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxLength: 250
     * - minLength: 1
     * @var string
     */
    public $description;
    /**
     * The cancelReserved
     * Meta informations extracted from the WSDL
     * - documentation: Indicator if any reserved (new) refunds should be canceled in favor of this refund. Default is false, meaning that this new refund is in addition to already reserved refunds.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $cancelReserved;
    /**
     * The requiredRefundDate
     * Meta informations extracted from the WSDL
     * - documentation: The date on which to refund. The first opportunity after this date for a refund will be used. The default is as soon as possible.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $requiredRefundDate;
    /**
     * The refundBankAccount
     * Meta informations extracted from the WSDL
     * - documentation: Optional, refund bank account information for payment methods for which no information is known to the system yet. If provided here, but not needed, then it will be ignored (e.g. for iDEAL or credit card refunds).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Docdata\StructType\SepaBankAccount
     */
    public $refundBankAccount;
    /**
     * The integrationInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Docdata\StructType\TechnicalIntegrationInfo
     */
    public $integrationInfo;
    /**
     * The testExtensibility
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Test extensibility of client implementation by returning test elements and attributes indicated by with the names and string value "_any".
     * - use: optional
     * @var bool
     */
    public $testExtensibility;
    /**
     * Constructor method for refundRequest
     * @uses RefundRequest::setMerchant()
     * @uses RefundRequest::setPaymentId()
     * @uses RefundRequest::setRefundItems()
     * @uses RefundRequest::setVersion()
     * @uses RefundRequest::setMerchantRefundReference()
     * @uses RefundRequest::setAmount()
     * @uses RefundRequest::setItemCode()
     * @uses RefundRequest::setDescription()
     * @uses RefundRequest::setCancelReserved()
     * @uses RefundRequest::setRequiredRefundDate()
     * @uses RefundRequest::setRefundBankAccount()
     * @uses RefundRequest::setIntegrationInfo()
     * @uses RefundRequest::setTestExtensibility()
     * @param \Docdata\StructType\Merchant $merchant
     * @param int $paymentId
     * @param \Docdata\StructType\RefundItems $refundItems
     * @param float $version
     * @param string $merchantRefundReference
     * @param \Docdata\StructType\Amount $amount
     * @param string $itemCode
     * @param string $description
     * @param bool $cancelReserved
     * @param string $requiredRefundDate
     * @param \Docdata\StructType\SepaBankAccount $refundBankAccount
     * @param \Docdata\StructType\TechnicalIntegrationInfo $integrationInfo
     * @param bool $testExtensibility
     */
    public function __construct(\Docdata\StructType\Merchant $merchant = null, $paymentId = null, \Docdata\StructType\RefundItems $refundItems = null, $version = null, $merchantRefundReference = null, \Docdata\StructType\Amount $amount = null, $itemCode = null, $description = null, $cancelReserved = null, $requiredRefundDate = null, \Docdata\StructType\SepaBankAccount $refundBankAccount = null, \Docdata\StructType\TechnicalIntegrationInfo $integrationInfo = null, $testExtensibility = false)
    {
        $this
            ->setMerchant($merchant)
            ->setPaymentId($paymentId)
            ->setRefundItems($refundItems)
            ->setVersion($version)
            ->setMerchantRefundReference($merchantRefundReference)
            ->setAmount($amount)
            ->setItemCode($itemCode)
            ->setDescription($description)
            ->setCancelReserved($cancelReserved)
            ->setRequiredRefundDate($requiredRefundDate)
            ->setRefundBankAccount($refundBankAccount)
            ->setIntegrationInfo($integrationInfo)
            ->setTestExtensibility($testExtensibility);
    }
    /**
     * Get merchant value
     * @return \Docdata\StructType\Merchant
     */
    public function getMerchant()
    {
        return $this->merchant;
    }
    /**
     * Set merchant value
     * @param \Docdata\StructType\Merchant $merchant
     * @return \Docdata\StructType\RefundRequest
     */
    public function setMerchant(\Docdata\StructType\Merchant $merchant = null)
    {
        $this->merchant = $merchant;
        return $this;
    }
    /**
     * Get paymentId value
     * @return int
     */
    public function getPaymentId()
    {
        return $this->paymentId;
    }
    /**
     * Set paymentId value
     * @param int $paymentId
     * @return \Docdata\StructType\RefundRequest
     */
    public function setPaymentId($paymentId = null)
    {
        // validation for constraint: int
        if (!is_null($paymentId) && !is_numeric($paymentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentId)), __LINE__);
        }
        $this->paymentId = $paymentId;
        return $this;
    }
    /**
     * Get refundItems value
     * @return \Docdata\StructType\RefundItems
     */
    public function getRefundItems()
    {
        return $this->refundItems;
    }
    /**
     * Set refundItems value
     * @param \Docdata\StructType\RefundItems $refundItems
     * @return \Docdata\StructType\RefundRequest
     */
    public function setRefundItems(\Docdata\StructType\RefundItems $refundItems = null)
    {
        $this->refundItems = $refundItems;
        return $this;
    }
    /**
     * Get version value
     * @return float
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param float $version
     * @return \Docdata\StructType\RefundRequest
     */
    public function setVersion($version = null)
    {
        $this->version = $version;
        return $this;
    }
    /**
     * Get merchantRefundReference value
     * @return string|null
     */
    public function getMerchantRefundReference()
    {
        return $this->merchantRefundReference;
    }
    /**
     * Set merchantRefundReference value
     * @param string $merchantRefundReference
     * @return \Docdata\StructType\RefundRequest
     */
    public function setMerchantRefundReference($merchantRefundReference = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($merchantRefundReference) && strlen($merchantRefundReference) > 35) || (is_array($merchantRefundReference) && count($merchantRefundReference) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($merchantRefundReference) ? strlen($merchantRefundReference) : count($merchantRefundReference)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($merchantRefundReference) && strlen($merchantRefundReference) < 1) || (is_array($merchantRefundReference) && count($merchantRefundReference) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($merchantRefundReference) && !is_string($merchantRefundReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($merchantRefundReference)), __LINE__);
        }
        $this->merchantRefundReference = $merchantRefundReference;
        return $this;
    }
    /**
     * Get amount value
     * @return \Docdata\StructType\Amount|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param \Docdata\StructType\Amount $amount
     * @return \Docdata\StructType\RefundRequest
     */
    public function setAmount(\Docdata\StructType\Amount $amount = null)
    {
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get itemCode value
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->itemCode;
    }
    /**
     * Set itemCode value
     * @param string $itemCode
     * @return \Docdata\StructType\RefundRequest
     */
    public function setItemCode($itemCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($itemCode) && strlen($itemCode) > 50) || (is_array($itemCode) && count($itemCode) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($itemCode) ? strlen($itemCode) : count($itemCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($itemCode) && strlen($itemCode) < 1) || (is_array($itemCode) && count($itemCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($itemCode) && !is_string($itemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemCode)), __LINE__);
        }
        $this->itemCode = $itemCode;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Docdata\StructType\RefundRequest
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 250) || (is_array($description) && count($description) > 250)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 250 element(s) or a scalar of 250 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($description) && strlen($description) < 1) || (is_array($description) && count($description) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get cancelReserved value
     * @return bool|null
     */
    public function getCancelReserved()
    {
        return $this->cancelReserved;
    }
    /**
     * Set cancelReserved value
     * @param bool $cancelReserved
     * @return \Docdata\StructType\RefundRequest
     */
    public function setCancelReserved($cancelReserved = null)
    {
        $this->cancelReserved = $cancelReserved;
        return $this;
    }
    /**
     * Get requiredRefundDate value
     * @return string|null
     */
    public function getRequiredRefundDate()
    {
        return $this->requiredRefundDate;
    }
    /**
     * Set requiredRefundDate value
     * @param string $requiredRefundDate
     * @return \Docdata\StructType\RefundRequest
     */
    public function setRequiredRefundDate($requiredRefundDate = null)
    {
        // validation for constraint: string
        if (!is_null($requiredRefundDate) && !is_string($requiredRefundDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requiredRefundDate)), __LINE__);
        }
        $this->requiredRefundDate = $requiredRefundDate;
        return $this;
    }
    /**
     * Get refundBankAccount value
     * @return \Docdata\StructType\SepaBankAccount|null
     */
    public function getRefundBankAccount()
    {
        return $this->refundBankAccount;
    }
    /**
     * Set refundBankAccount value
     * @param \Docdata\StructType\SepaBankAccount $refundBankAccount
     * @return \Docdata\StructType\RefundRequest
     */
    public function setRefundBankAccount(\Docdata\StructType\SepaBankAccount $refundBankAccount = null)
    {
        $this->refundBankAccount = $refundBankAccount;
        return $this;
    }
    /**
     * Get integrationInfo value
     * @return \Docdata\StructType\TechnicalIntegrationInfo|null
     */
    public function getIntegrationInfo()
    {
        return $this->integrationInfo;
    }
    /**
     * Set integrationInfo value
     * @param \Docdata\StructType\TechnicalIntegrationInfo $integrationInfo
     * @return \Docdata\StructType\RefundRequest
     */
    public function setIntegrationInfo(\Docdata\StructType\TechnicalIntegrationInfo $integrationInfo = null)
    {
        $this->integrationInfo = $integrationInfo;
        return $this;
    }
    /**
     * Get testExtensibility value
     * @return bool|null
     */
    public function getTestExtensibility()
    {
        return $this->testExtensibility;
    }
    /**
     * Set testExtensibility value
     * @param bool $testExtensibility
     * @return \Docdata\StructType\RefundRequest
     */
    public function setTestExtensibility($testExtensibility = false)
    {
        $this->testExtensibility = $testExtensibility;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\RefundRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
