<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for proceedResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: Response to a proceed request.
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class ProceedResponse extends AbstractStructBase
{
    /**
     * The proceedErrors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\ProceedErrors
     */
    public $proceedErrors;
    /**
     * The proceedSuccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\ProceedSuccess
     */
    public $proceedSuccess;
    /**
     * The ddpXsdVersion
     * Meta informations extracted from the WSDL
     * - use: required
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $ddpXsdVersion;
    /**
     * Constructor method for proceedResponse
     * @uses ProceedResponse::setProceedErrors()
     * @uses ProceedResponse::setProceedSuccess()
     * @uses ProceedResponse::setDdpXsdVersion()
     * @param \Docdata\StructType\ProceedErrors $proceedErrors
     * @param \Docdata\StructType\ProceedSuccess $proceedSuccess
     * @param string $ddpXsdVersion
     */
    public function __construct(\Docdata\StructType\ProceedErrors $proceedErrors = null, \Docdata\StructType\ProceedSuccess $proceedSuccess = null, $ddpXsdVersion = null)
    {
        $this
            ->setProceedErrors($proceedErrors)
            ->setProceedSuccess($proceedSuccess)
            ->setDdpXsdVersion($ddpXsdVersion);
    }
    /**
     * Get proceedErrors value
     * @return \Docdata\StructType\ProceedErrors
     */
    public function getProceedErrors()
    {
        return $this->proceedErrors;
    }
    /**
     * Set proceedErrors value
     * @param \Docdata\StructType\ProceedErrors $proceedErrors
     * @return \Docdata\StructType\ProceedResponse
     */
    public function setProceedErrors(\Docdata\StructType\ProceedErrors $proceedErrors = null)
    {
        $this->proceedErrors = $proceedErrors;
        return $this;
    }
    /**
     * Get proceedSuccess value
     * @return \Docdata\StructType\ProceedSuccess
     */
    public function getProceedSuccess()
    {
        return $this->proceedSuccess;
    }
    /**
     * Set proceedSuccess value
     * @param \Docdata\StructType\ProceedSuccess $proceedSuccess
     * @return \Docdata\StructType\ProceedResponse
     */
    public function setProceedSuccess(\Docdata\StructType\ProceedSuccess $proceedSuccess = null)
    {
        $this->proceedSuccess = $proceedSuccess;
        return $this;
    }
    /**
     * Get ddpXsdVersion value
     * @return string
     */
    public function getDdpXsdVersion()
    {
        return $this->ddpXsdVersion;
    }
    /**
     * Set ddpXsdVersion value
     * @param string $ddpXsdVersion
     * @return \Docdata\StructType\ProceedResponse
     */
    public function setDdpXsdVersion($ddpXsdVersion = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ddpXsdVersion) && strlen($ddpXsdVersion) > 35) || (is_array($ddpXsdVersion) && count($ddpXsdVersion) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($ddpXsdVersion) ? strlen($ddpXsdVersion) : count($ddpXsdVersion)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($ddpXsdVersion) && strlen($ddpXsdVersion) < 1) || (is_array($ddpXsdVersion) && count($ddpXsdVersion) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ddpXsdVersion) && !is_string($ddpXsdVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ddpXsdVersion)), __LINE__);
        }
        $this->ddpXsdVersion = $ddpXsdVersion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\ProceedResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
