<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paymentInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Extended payment information e.g. risk check scores and payment-specific information. | Note: there is no paymentInfo for PayPal, PaySafeCard, GiroPay, EPS and PostFinance. They only provide their PaymentMethodName. See the
 * payment-element.
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class PaymentInfo extends AbstractStructBase
{
    /**
     * The amexPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\AmexPaymentInfo
     */
    public $amexPaymentInfo;
    /**
     * The masterCardPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\MasterCardPaymentInfo
     */
    public $masterCardPaymentInfo;
    /**
     * The visaPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\VisaPaymentInfo
     */
    public $visaPaymentInfo;
    /**
     * The bankTransferPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\BankTransferPaymentInfo
     */
    public $bankTransferPaymentInfo;
    /**
     * The maestroPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\MaestroPaymentInfo
     */
    public $maestroPaymentInfo;
    /**
     * The misterCashPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\MisterCashPaymentInfo
     */
    public $misterCashPaymentInfo;
    /**
     * The giftCardPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\GiftCardPaymentInfo
     */
    public $giftCardPaymentInfo;
    /**
     * The iDealPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\IDealPaymentInfo
     */
    public $iDealPaymentInfo;
    /**
     * The afterpayOpenInvoicePaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\OpenInvoicePaymentInfo
     */
    public $afterpayOpenInvoicePaymentInfo;
    /**
     * The afterpayDirectDebitPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\OpenInvoicePaymentInfo
     */
    public $afterpayDirectDebitPaymentInfo;
    /**
     * The klarnaInvoicePaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\OpenInvoicePaymentInfo
     */
    public $klarnaInvoicePaymentInfo;
    /**
     * The klarnaAccountPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\OpenInvoicePaymentInfo
     */
    public $klarnaAccountPaymentInfo;
    /**
     * The elvPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\ElvPaymentInfo
     */
    public $elvPaymentInfo;
    /**
     * The sepaDirectDebitPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\SepaDirectDebitPaymentInfo
     */
    public $sepaDirectDebitPaymentInfo;
    /**
     * The pointOfSalePaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\PointOfSalePaymentInfo
     */
    public $pointOfSalePaymentInfo;
    /**
     * The offlinePaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\OfflinePaymentInfo
     */
    public $offlinePaymentInfo;
    /**
     * The sofortUeberweisungPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\SofortPaymentInfo
     */
    public $sofortUeberweisungPaymentInfo;
    /**
     * The eBankingPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\SofortPaymentInfo
     */
    public $eBankingPaymentInfo;
    /**
     * The systemPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\SystemPaymentInfo
     */
    public $systemPaymentInfo;
    /**
     * The riskChecks
     * Meta informations extracted from the WSDL
     * - documentation: Risk checks are controls which can prevent fraud. They can be configured in the back office.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Docdata\StructType\RiskCheck
     */
    public $riskChecks;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for paymentInfo
     * @uses PaymentInfo::setAmexPaymentInfo()
     * @uses PaymentInfo::setMasterCardPaymentInfo()
     * @uses PaymentInfo::setVisaPaymentInfo()
     * @uses PaymentInfo::setBankTransferPaymentInfo()
     * @uses PaymentInfo::setMaestroPaymentInfo()
     * @uses PaymentInfo::setMisterCashPaymentInfo()
     * @uses PaymentInfo::setGiftCardPaymentInfo()
     * @uses PaymentInfo::setIDealPaymentInfo()
     * @uses PaymentInfo::setAfterpayOpenInvoicePaymentInfo()
     * @uses PaymentInfo::setAfterpayDirectDebitPaymentInfo()
     * @uses PaymentInfo::setKlarnaInvoicePaymentInfo()
     * @uses PaymentInfo::setKlarnaAccountPaymentInfo()
     * @uses PaymentInfo::setElvPaymentInfo()
     * @uses PaymentInfo::setSepaDirectDebitPaymentInfo()
     * @uses PaymentInfo::setPointOfSalePaymentInfo()
     * @uses PaymentInfo::setOfflinePaymentInfo()
     * @uses PaymentInfo::setSofortUeberweisungPaymentInfo()
     * @uses PaymentInfo::setEBankingPaymentInfo()
     * @uses PaymentInfo::setSystemPaymentInfo()
     * @uses PaymentInfo::setRiskChecks()
     * @uses PaymentInfo::setAny()
     * @param \Docdata\StructType\AmexPaymentInfo $amexPaymentInfo
     * @param \Docdata\StructType\MasterCardPaymentInfo $masterCardPaymentInfo
     * @param \Docdata\StructType\VisaPaymentInfo $visaPaymentInfo
     * @param \Docdata\StructType\BankTransferPaymentInfo $bankTransferPaymentInfo
     * @param \Docdata\StructType\MaestroPaymentInfo $maestroPaymentInfo
     * @param \Docdata\StructType\MisterCashPaymentInfo $misterCashPaymentInfo
     * @param \Docdata\StructType\GiftCardPaymentInfo $giftCardPaymentInfo
     * @param \Docdata\StructType\IDealPaymentInfo $iDealPaymentInfo
     * @param \Docdata\StructType\OpenInvoicePaymentInfo $afterpayOpenInvoicePaymentInfo
     * @param \Docdata\StructType\OpenInvoicePaymentInfo $afterpayDirectDebitPaymentInfo
     * @param \Docdata\StructType\OpenInvoicePaymentInfo $klarnaInvoicePaymentInfo
     * @param \Docdata\StructType\OpenInvoicePaymentInfo $klarnaAccountPaymentInfo
     * @param \Docdata\StructType\ElvPaymentInfo $elvPaymentInfo
     * @param \Docdata\StructType\SepaDirectDebitPaymentInfo $sepaDirectDebitPaymentInfo
     * @param \Docdata\StructType\PointOfSalePaymentInfo $pointOfSalePaymentInfo
     * @param \Docdata\StructType\OfflinePaymentInfo $offlinePaymentInfo
     * @param \Docdata\StructType\SofortPaymentInfo $sofortUeberweisungPaymentInfo
     * @param \Docdata\StructType\SofortPaymentInfo $eBankingPaymentInfo
     * @param \Docdata\StructType\SystemPaymentInfo $systemPaymentInfo
     * @param \Docdata\StructType\RiskCheck $riskChecks
     * @param \DOMDocument $any
     */
    public function __construct(\Docdata\StructType\AmexPaymentInfo $amexPaymentInfo = null, \Docdata\StructType\MasterCardPaymentInfo $masterCardPaymentInfo = null, \Docdata\StructType\VisaPaymentInfo $visaPaymentInfo = null, \Docdata\StructType\BankTransferPaymentInfo $bankTransferPaymentInfo = null, \Docdata\StructType\MaestroPaymentInfo $maestroPaymentInfo = null, \Docdata\StructType\MisterCashPaymentInfo $misterCashPaymentInfo = null, \Docdata\StructType\GiftCardPaymentInfo $giftCardPaymentInfo = null, \Docdata\StructType\IDealPaymentInfo $iDealPaymentInfo = null, \Docdata\StructType\OpenInvoicePaymentInfo $afterpayOpenInvoicePaymentInfo = null, \Docdata\StructType\OpenInvoicePaymentInfo $afterpayDirectDebitPaymentInfo = null, \Docdata\StructType\OpenInvoicePaymentInfo $klarnaInvoicePaymentInfo = null, \Docdata\StructType\OpenInvoicePaymentInfo $klarnaAccountPaymentInfo = null, \Docdata\StructType\ElvPaymentInfo $elvPaymentInfo = null, \Docdata\StructType\SepaDirectDebitPaymentInfo $sepaDirectDebitPaymentInfo = null, \Docdata\StructType\PointOfSalePaymentInfo $pointOfSalePaymentInfo = null, \Docdata\StructType\OfflinePaymentInfo $offlinePaymentInfo = null, \Docdata\StructType\SofortPaymentInfo $sofortUeberweisungPaymentInfo = null, \Docdata\StructType\SofortPaymentInfo $eBankingPaymentInfo = null, \Docdata\StructType\SystemPaymentInfo $systemPaymentInfo = null, \Docdata\StructType\RiskCheck $riskChecks = null, \DOMDocument $any = null)
    {
        $this
            ->setAmexPaymentInfo($amexPaymentInfo)
            ->setMasterCardPaymentInfo($masterCardPaymentInfo)
            ->setVisaPaymentInfo($visaPaymentInfo)
            ->setBankTransferPaymentInfo($bankTransferPaymentInfo)
            ->setMaestroPaymentInfo($maestroPaymentInfo)
            ->setMisterCashPaymentInfo($misterCashPaymentInfo)
            ->setGiftCardPaymentInfo($giftCardPaymentInfo)
            ->setIDealPaymentInfo($iDealPaymentInfo)
            ->setAfterpayOpenInvoicePaymentInfo($afterpayOpenInvoicePaymentInfo)
            ->setAfterpayDirectDebitPaymentInfo($afterpayDirectDebitPaymentInfo)
            ->setKlarnaInvoicePaymentInfo($klarnaInvoicePaymentInfo)
            ->setKlarnaAccountPaymentInfo($klarnaAccountPaymentInfo)
            ->setElvPaymentInfo($elvPaymentInfo)
            ->setSepaDirectDebitPaymentInfo($sepaDirectDebitPaymentInfo)
            ->setPointOfSalePaymentInfo($pointOfSalePaymentInfo)
            ->setOfflinePaymentInfo($offlinePaymentInfo)
            ->setSofortUeberweisungPaymentInfo($sofortUeberweisungPaymentInfo)
            ->setEBankingPaymentInfo($eBankingPaymentInfo)
            ->setSystemPaymentInfo($systemPaymentInfo)
            ->setRiskChecks($riskChecks)
            ->setAny($any);
    }
    /**
     * Get amexPaymentInfo value
     * @return \Docdata\StructType\AmexPaymentInfo
     */
    public function getAmexPaymentInfo()
    {
        return $this->amexPaymentInfo;
    }
    /**
     * Set amexPaymentInfo value
     * @param \Docdata\StructType\AmexPaymentInfo $amexPaymentInfo
     * @return \Docdata\StructType\PaymentInfo
     */
    public function setAmexPaymentInfo(\Docdata\StructType\AmexPaymentInfo $amexPaymentInfo = null)
    {
        $this->amexPaymentInfo = $amexPaymentInfo;
        return $this;
    }
    /**
     * Get masterCardPaymentInfo value
     * @return \Docdata\StructType\MasterCardPaymentInfo
     */
    public function getMasterCardPaymentInfo()
    {
        return $this->masterCardPaymentInfo;
    }
    /**
     * Set masterCardPaymentInfo value
     * @param \Docdata\StructType\MasterCardPaymentInfo $masterCardPaymentInfo
     * @return \Docdata\StructType\PaymentInfo
     */
    public function setMasterCardPaymentInfo(\Docdata\StructType\MasterCardPaymentInfo $masterCardPaymentInfo = null)
    {
        $this->masterCardPaymentInfo = $masterCardPaymentInfo;
        return $this;
    }
    /**
     * Get visaPaymentInfo value
     * @return \Docdata\StructType\VisaPaymentInfo
     */
    public function getVisaPaymentInfo()
    {
        return $this->visaPaymentInfo;
    }
    /**
     * Set visaPaymentInfo value
     * @param \Docdata\StructType\VisaPaymentInfo $visaPaymentInfo
     * @return \Docdata\StructType\PaymentInfo
     */
    public function setVisaPaymentInfo(\Docdata\StructType\VisaPaymentInfo $visaPaymentInfo = null)
    {
        $this->visaPaymentInfo = $visaPaymentInfo;
        return $this;
    }
    /**
     * Get bankTransferPaymentInfo value
     * @return \Docdata\StructType\BankTransferPaymentInfo
     */
    public function getBankTransferPaymentInfo()
    {
        return $this->bankTransferPaymentInfo;
    }
    /**
     * Set bankTransferPaymentInfo value
     * @param \Docdata\StructType\BankTransferPaymentInfo $bankTransferPaymentInfo
     * @return \Docdata\StructType\PaymentInfo
     */
    public function setBankTransferPaymentInfo(\Docdata\StructType\BankTransferPaymentInfo $bankTransferPaymentInfo = null)
    {
        $this->bankTransferPaymentInfo = $bankTransferPaymentInfo;
        return $this;
    }
    /**
     * Get maestroPaymentInfo value
     * @return \Docdata\StructType\MaestroPaymentInfo
     */
    public function getMaestroPaymentInfo()
    {
        return $this->maestroPaymentInfo;
    }
    /**
     * Set maestroPaymentInfo value
     * @param \Docdata\StructType\MaestroPaymentInfo $maestroPaymentInfo
     * @return \Docdata\StructType\PaymentInfo
     */
    public function setMaestroPaymentInfo(\Docdata\StructType\MaestroPaymentInfo $maestroPaymentInfo = null)
    {
        $this->maestroPaymentInfo = $maestroPaymentInfo;
        return $this;
    }
    /**
     * Get misterCashPaymentInfo value
     * @return \Docdata\StructType\MisterCashPaymentInfo
     */
    public function getMisterCashPaymentInfo()
    {
        return $this->misterCashPaymentInfo;
    }
    /**
     * Set misterCashPaymentInfo value
     * @param \Docdata\StructType\MisterCashPaymentInfo $misterCashPaymentInfo
     * @return \Docdata\StructType\PaymentInfo
     */
    public function setMisterCashPaymentInfo(\Docdata\StructType\MisterCashPaymentInfo $misterCashPaymentInfo = null)
    {
        $this->misterCashPaymentInfo = $misterCashPaymentInfo;
        return $this;
    }
    /**
     * Get giftCardPaymentInfo value
     * @return \Docdata\StructType\GiftCardPaymentInfo
     */
    public function getGiftCardPaymentInfo()
    {
        return $this->giftCardPaymentInfo;
    }
    /**
     * Set giftCardPaymentInfo value
     * @param \Docdata\StructType\GiftCardPaymentInfo $giftCardPaymentInfo
     * @return \Docdata\StructType\PaymentInfo
     */
    public function setGiftCardPaymentInfo(\Docdata\StructType\GiftCardPaymentInfo $giftCardPaymentInfo = null)
    {
        $this->giftCardPaymentInfo = $giftCardPaymentInfo;
        return $this;
    }
    /**
     * Get iDealPaymentInfo value
     * @return \Docdata\StructType\IDealPaymentInfo
     */
    public function getIDealPaymentInfo()
    {
        return $this->iDealPaymentInfo;
    }
    /**
     * Set iDealPaymentInfo value
     * @param \Docdata\StructType\IDealPaymentInfo $iDealPaymentInfo
     * @return \Docdata\StructType\PaymentInfo
     */
    public function setIDealPaymentInfo(\Docdata\StructType\IDealPaymentInfo $iDealPaymentInfo = null)
    {
        $this->iDealPaymentInfo = $iDealPaymentInfo;
        return $this;
    }
    /**
     * Get afterpayOpenInvoicePaymentInfo value
     * @return \Docdata\StructType\OpenInvoicePaymentInfo
     */
    public function getAfterpayOpenInvoicePaymentInfo()
    {
        return $this->afterpayOpenInvoicePaymentInfo;
    }
    /**
     * Set afterpayOpenInvoicePaymentInfo value
     * @param \Docdata\StructType\OpenInvoicePaymentInfo $afterpayOpenInvoicePaymentInfo
     * @return \Docdata\StructType\PaymentInfo
     */
    public function setAfterpayOpenInvoicePaymentInfo(\Docdata\StructType\OpenInvoicePaymentInfo $afterpayOpenInvoicePaymentInfo = null)
    {
        $this->afterpayOpenInvoicePaymentInfo = $afterpayOpenInvoicePaymentInfo;
        return $this;
    }
    /**
     * Get afterpayDirectDebitPaymentInfo value
     * @return \Docdata\StructType\OpenInvoicePaymentInfo
     */
    public function getAfterpayDirectDebitPaymentInfo()
    {
        return $this->afterpayDirectDebitPaymentInfo;
    }
    /**
     * Set afterpayDirectDebitPaymentInfo value
     * @param \Docdata\StructType\OpenInvoicePaymentInfo $afterpayDirectDebitPaymentInfo
     * @return \Docdata\StructType\PaymentInfo
     */
    public function setAfterpayDirectDebitPaymentInfo(\Docdata\StructType\OpenInvoicePaymentInfo $afterpayDirectDebitPaymentInfo = null)
    {
        $this->afterpayDirectDebitPaymentInfo = $afterpayDirectDebitPaymentInfo;
        return $this;
    }
    /**
     * Get klarnaInvoicePaymentInfo value
     * @return \Docdata\StructType\OpenInvoicePaymentInfo
     */
    public function getKlarnaInvoicePaymentInfo()
    {
        return $this->klarnaInvoicePaymentInfo;
    }
    /**
     * Set klarnaInvoicePaymentInfo value
     * @param \Docdata\StructType\OpenInvoicePaymentInfo $klarnaInvoicePaymentInfo
     * @return \Docdata\StructType\PaymentInfo
     */
    public function setKlarnaInvoicePaymentInfo(\Docdata\StructType\OpenInvoicePaymentInfo $klarnaInvoicePaymentInfo = null)
    {
        $this->klarnaInvoicePaymentInfo = $klarnaInvoicePaymentInfo;
        return $this;
    }
    /**
     * Get klarnaAccountPaymentInfo value
     * @return \Docdata\StructType\OpenInvoicePaymentInfo
     */
    public function getKlarnaAccountPaymentInfo()
    {
        return $this->klarnaAccountPaymentInfo;
    }
    /**
     * Set klarnaAccountPaymentInfo value
     * @param \Docdata\StructType\OpenInvoicePaymentInfo $klarnaAccountPaymentInfo
     * @return \Docdata\StructType\PaymentInfo
     */
    public function setKlarnaAccountPaymentInfo(\Docdata\StructType\OpenInvoicePaymentInfo $klarnaAccountPaymentInfo = null)
    {
        $this->klarnaAccountPaymentInfo = $klarnaAccountPaymentInfo;
        return $this;
    }
    /**
     * Get elvPaymentInfo value
     * @return \Docdata\StructType\ElvPaymentInfo
     */
    public function getElvPaymentInfo()
    {
        return $this->elvPaymentInfo;
    }
    /**
     * Set elvPaymentInfo value
     * @param \Docdata\StructType\ElvPaymentInfo $elvPaymentInfo
     * @return \Docdata\StructType\PaymentInfo
     */
    public function setElvPaymentInfo(\Docdata\StructType\ElvPaymentInfo $elvPaymentInfo = null)
    {
        $this->elvPaymentInfo = $elvPaymentInfo;
        return $this;
    }
    /**
     * Get sepaDirectDebitPaymentInfo value
     * @return \Docdata\StructType\SepaDirectDebitPaymentInfo
     */
    public function getSepaDirectDebitPaymentInfo()
    {
        return $this->sepaDirectDebitPaymentInfo;
    }
    /**
     * Set sepaDirectDebitPaymentInfo value
     * @param \Docdata\StructType\SepaDirectDebitPaymentInfo $sepaDirectDebitPaymentInfo
     * @return \Docdata\StructType\PaymentInfo
     */
    public function setSepaDirectDebitPaymentInfo(\Docdata\StructType\SepaDirectDebitPaymentInfo $sepaDirectDebitPaymentInfo = null)
    {
        $this->sepaDirectDebitPaymentInfo = $sepaDirectDebitPaymentInfo;
        return $this;
    }
    /**
     * Get pointOfSalePaymentInfo value
     * @return \Docdata\StructType\PointOfSalePaymentInfo
     */
    public function getPointOfSalePaymentInfo()
    {
        return $this->pointOfSalePaymentInfo;
    }
    /**
     * Set pointOfSalePaymentInfo value
     * @param \Docdata\StructType\PointOfSalePaymentInfo $pointOfSalePaymentInfo
     * @return \Docdata\StructType\PaymentInfo
     */
    public function setPointOfSalePaymentInfo(\Docdata\StructType\PointOfSalePaymentInfo $pointOfSalePaymentInfo = null)
    {
        $this->pointOfSalePaymentInfo = $pointOfSalePaymentInfo;
        return $this;
    }
    /**
     * Get offlinePaymentInfo value
     * @return \Docdata\StructType\OfflinePaymentInfo
     */
    public function getOfflinePaymentInfo()
    {
        return $this->offlinePaymentInfo;
    }
    /**
     * Set offlinePaymentInfo value
     * @param \Docdata\StructType\OfflinePaymentInfo $offlinePaymentInfo
     * @return \Docdata\StructType\PaymentInfo
     */
    public function setOfflinePaymentInfo(\Docdata\StructType\OfflinePaymentInfo $offlinePaymentInfo = null)
    {
        $this->offlinePaymentInfo = $offlinePaymentInfo;
        return $this;
    }
    /**
     * Get sofortUeberweisungPaymentInfo value
     * @return \Docdata\StructType\SofortPaymentInfo
     */
    public function getSofortUeberweisungPaymentInfo()
    {
        return $this->sofortUeberweisungPaymentInfo;
    }
    /**
     * Set sofortUeberweisungPaymentInfo value
     * @param \Docdata\StructType\SofortPaymentInfo $sofortUeberweisungPaymentInfo
     * @return \Docdata\StructType\PaymentInfo
     */
    public function setSofortUeberweisungPaymentInfo(\Docdata\StructType\SofortPaymentInfo $sofortUeberweisungPaymentInfo = null)
    {
        $this->sofortUeberweisungPaymentInfo = $sofortUeberweisungPaymentInfo;
        return $this;
    }
    /**
     * Get eBankingPaymentInfo value
     * @return \Docdata\StructType\SofortPaymentInfo
     */
    public function getEBankingPaymentInfo()
    {
        return $this->eBankingPaymentInfo;
    }
    /**
     * Set eBankingPaymentInfo value
     * @param \Docdata\StructType\SofortPaymentInfo $eBankingPaymentInfo
     * @return \Docdata\StructType\PaymentInfo
     */
    public function setEBankingPaymentInfo(\Docdata\StructType\SofortPaymentInfo $eBankingPaymentInfo = null)
    {
        $this->eBankingPaymentInfo = $eBankingPaymentInfo;
        return $this;
    }
    /**
     * Get systemPaymentInfo value
     * @return \Docdata\StructType\SystemPaymentInfo
     */
    public function getSystemPaymentInfo()
    {
        return $this->systemPaymentInfo;
    }
    /**
     * Set systemPaymentInfo value
     * @param \Docdata\StructType\SystemPaymentInfo $systemPaymentInfo
     * @return \Docdata\StructType\PaymentInfo
     */
    public function setSystemPaymentInfo(\Docdata\StructType\SystemPaymentInfo $systemPaymentInfo = null)
    {
        $this->systemPaymentInfo = $systemPaymentInfo;
        return $this;
    }
    /**
     * Get riskChecks value
     * @return \Docdata\StructType\RiskCheck|null
     */
    public function getRiskChecks()
    {
        return $this->riskChecks;
    }
    /**
     * Set riskChecks value
     * @param \Docdata\StructType\RiskCheck $riskChecks
     * @return \Docdata\StructType\PaymentInfo
     */
    public function setRiskChecks(\Docdata\StructType\RiskCheck $riskChecks = null)
    {
        $this->riskChecks = $riskChecks;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Docdata\StructType\PaymentInfo::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Docdata\StructType\PaymentInfo
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\PaymentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
