<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for payment StructType
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class Payment extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: The payment ID with check digit as generated by the payment system.
     * @var int
     */
    public $id;
    /**
     * The paymentMethod
     * Meta informations extracted from the WSDL
     * - documentation: Payment method used for the payment.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $paymentMethod;
    /**
     * The authorization
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\Authorization
     */
    public $authorization;
    /**
     * The extended
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Docdata\StructType\PaymentInfo
     */
    public $extended;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for payment
     * @uses Payment::setId()
     * @uses Payment::setPaymentMethod()
     * @uses Payment::setAuthorization()
     * @uses Payment::setExtended()
     * @uses Payment::setAny()
     * @param int $id
     * @param string $paymentMethod
     * @param \Docdata\StructType\Authorization $authorization
     * @param \Docdata\StructType\PaymentInfo $extended
     * @param \DOMDocument $any
     */
    public function __construct($id = null, $paymentMethod = null, \Docdata\StructType\Authorization $authorization = null, \Docdata\StructType\PaymentInfo $extended = null, \DOMDocument $any = null)
    {
        $this
            ->setId($id)
            ->setPaymentMethod($paymentMethod)
            ->setAuthorization($authorization)
            ->setExtended($extended)
            ->setAny($any);
    }
    /**
     * Get id value
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \Docdata\StructType\Payment
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get paymentMethod value
     * @return string
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }
    /**
     * Set paymentMethod value
     * @param string $paymentMethod
     * @return \Docdata\StructType\Payment
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($paymentMethod) && strlen($paymentMethod) > 50) || (is_array($paymentMethod) && count($paymentMethod) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($paymentMethod) ? strlen($paymentMethod) : count($paymentMethod)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($paymentMethod) && strlen($paymentMethod) < 1) || (is_array($paymentMethod) && count($paymentMethod) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentMethod)), __LINE__);
        }
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get authorization value
     * @return \Docdata\StructType\Authorization
     */
    public function getAuthorization()
    {
        return $this->authorization;
    }
    /**
     * Set authorization value
     * @param \Docdata\StructType\Authorization $authorization
     * @return \Docdata\StructType\Payment
     */
    public function setAuthorization(\Docdata\StructType\Authorization $authorization = null)
    {
        $this->authorization = $authorization;
        return $this;
    }
    /**
     * Get extended value
     * @return \Docdata\StructType\PaymentInfo|null
     */
    public function getExtended()
    {
        return $this->extended;
    }
    /**
     * Set extended value
     * @param \Docdata\StructType\PaymentInfo $extended
     * @return \Docdata\StructType\Payment
     */
    public function setExtended(\Docdata\StructType\PaymentInfo $extended = null)
    {
        $this->extended = $extended;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Docdata\StructType\Payment::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Docdata\StructType\Payment
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\Payment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
