<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mandateSummary StructType
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class MandateSummary extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: The identifier of the mandate, which should be passed along to the payment if the mandate is used for a payment.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 512
     * - minLength: 1
     * @var string
     */
    public $id;
    /**
     * The scheme
     * Meta informations extracted from the WSDL
     * - documentation: The scheme of the mandate. Possible values are: SEPA Direct Debit mandate, which can be used for business-to-business or business-to-consumer. SEPA Direct Debit mandate, which can be used for business-to-business or
     * business-to-consumer, with direct collection. SEPA Direct Debit mandate, which can only be used for business-to-business.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $scheme;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: The type of the mandate. Possible values are: The mandate can be used for one-off (non-recurring) payments. The mandate can be used for recurring payments.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The state
     * Meta informations extracted from the WSDL
     * - documentation: The state of the mandate. Possible values are: The mandate is signed and can be used for payments. It is still uncertain if an actual payment will succeed. The mandate is signed and can be used for payments. At least one payment
     * succeeded with this mandate. The mandate is new and not yet signed by the debtor. The mandate cannot be used at any time (e.g. bank account does not exist anymore). The mandate is rejected by the debtor's bank.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $state;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for mandateSummary
     * @uses MandateSummary::setId()
     * @uses MandateSummary::setScheme()
     * @uses MandateSummary::setType()
     * @uses MandateSummary::setState()
     * @uses MandateSummary::setAny()
     * @param string $id
     * @param string $scheme
     * @param string $type
     * @param string $state
     * @param \DOMDocument $any
     */
    public function __construct($id = null, $scheme = null, $type = null, $state = null, \DOMDocument $any = null)
    {
        $this
            ->setId($id)
            ->setScheme($scheme)
            ->setType($type)
            ->setState($state)
            ->setAny($any);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \Docdata\StructType\MandateSummary
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 512) || (is_array($id) && count($id) > 512)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 512 element(s) or a scalar of 512 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get scheme value
     * @return string
     */
    public function getScheme()
    {
        return $this->scheme;
    }
    /**
     * Set scheme value
     * @param string $scheme
     * @return \Docdata\StructType\MandateSummary
     */
    public function setScheme($scheme = null)
    {
        // validation for constraint: string
        if (!is_null($scheme) && !is_string($scheme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scheme)), __LINE__);
        }
        $this->scheme = $scheme;
        return $this;
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \Docdata\StructType\MandateSummary
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get state value
     * @return string
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \Docdata\StructType\MandateSummary
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Docdata\StructType\MandateSummary::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Docdata\StructType\MandateSummary
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\MandateSummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
