<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for elvPaymentInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: ELV payment information.
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class ElvPaymentInfo extends AbstractStructBase
{
    /**
     * The bankCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $bankCode;
    /**
     * The bankAccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $bankAccountNumber;
    /**
     * The shopperBankAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Docdata\StructType\ShopperBankAccount
     */
    public $shopperBankAccount;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for elvPaymentInfo
     * @uses ElvPaymentInfo::setBankCode()
     * @uses ElvPaymentInfo::setBankAccountNumber()
     * @uses ElvPaymentInfo::setShopperBankAccount()
     * @uses ElvPaymentInfo::setAny()
     * @param string $bankCode
     * @param string $bankAccountNumber
     * @param \Docdata\StructType\ShopperBankAccount $shopperBankAccount
     * @param \DOMDocument $any
     */
    public function __construct($bankCode = null, $bankAccountNumber = null, \Docdata\StructType\ShopperBankAccount $shopperBankAccount = null, \DOMDocument $any = null)
    {
        $this
            ->setBankCode($bankCode)
            ->setBankAccountNumber($bankAccountNumber)
            ->setShopperBankAccount($shopperBankAccount)
            ->setAny($any);
    }
    /**
     * Get bankCode value
     * @return string|null
     */
    public function getBankCode()
    {
        return $this->bankCode;
    }
    /**
     * Set bankCode value
     * @param string $bankCode
     * @return \Docdata\StructType\ElvPaymentInfo
     */
    public function setBankCode($bankCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bankCode) && strlen($bankCode) > 35) || (is_array($bankCode) && count($bankCode) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($bankCode) ? strlen($bankCode) : count($bankCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($bankCode) && strlen($bankCode) < 1) || (is_array($bankCode) && count($bankCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bankCode) && !is_string($bankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankCode)), __LINE__);
        }
        $this->bankCode = $bankCode;
        return $this;
    }
    /**
     * Get bankAccountNumber value
     * @return string|null
     */
    public function getBankAccountNumber()
    {
        return $this->bankAccountNumber;
    }
    /**
     * Set bankAccountNumber value
     * @param string $bankAccountNumber
     * @return \Docdata\StructType\ElvPaymentInfo
     */
    public function setBankAccountNumber($bankAccountNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bankAccountNumber) && strlen($bankAccountNumber) > 50) || (is_array($bankAccountNumber) && count($bankAccountNumber) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($bankAccountNumber) ? strlen($bankAccountNumber) : count($bankAccountNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($bankAccountNumber) && strlen($bankAccountNumber) < 1) || (is_array($bankAccountNumber) && count($bankAccountNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bankAccountNumber) && !is_string($bankAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankAccountNumber)), __LINE__);
        }
        $this->bankAccountNumber = $bankAccountNumber;
        return $this;
    }
    /**
     * Get shopperBankAccount value
     * @return \Docdata\StructType\ShopperBankAccount|null
     */
    public function getShopperBankAccount()
    {
        return $this->shopperBankAccount;
    }
    /**
     * Set shopperBankAccount value
     * @param \Docdata\StructType\ShopperBankAccount $shopperBankAccount
     * @return \Docdata\StructType\ElvPaymentInfo
     */
    public function setShopperBankAccount(\Docdata\StructType\ShopperBankAccount $shopperBankAccount = null)
    {
        $this->shopperBankAccount = $shopperBankAccount;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Docdata\StructType\ElvPaymentInfo::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Docdata\StructType\ElvPaymentInfo
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\ElvPaymentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
