<?php

namespace Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createSuccess StructType
 * @subpackage Structs
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class CreateSuccess extends AbstractStructBase
{
    /**
     * The success
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Docdata\StructType\Success
     */
    public $success;
    /**
     * The key
     * Meta informations extracted from the WSDL
     * - documentation: Generated key identifying the merchant and payment order.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 32
     * - minLength: 32
     * - pattern: [A-Z,0-9]{32}
     * @var string
     */
    public $key;
    /**
     * The paymentResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Docdata\StructType\PaymentResponse
     */
    public $paymentResponse;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for createSuccess
     * @uses CreateSuccess::setSuccess()
     * @uses CreateSuccess::setKey()
     * @uses CreateSuccess::setPaymentResponse()
     * @uses CreateSuccess::setAny()
     * @param \Docdata\StructType\Success $success
     * @param string $key
     * @param \Docdata\StructType\PaymentResponse $paymentResponse
     * @param \DOMDocument $any
     */
    public function __construct(\Docdata\StructType\Success $success = null, $key = null, \Docdata\StructType\PaymentResponse $paymentResponse = null, \DOMDocument $any = null)
    {
        $this
            ->setSuccess($success)
            ->setKey($key)
            ->setPaymentResponse($paymentResponse)
            ->setAny($any);
    }
    /**
     * Get success value
     * @return \Docdata\StructType\Success
     */
    public function getSuccess()
    {
        return $this->success;
    }
    /**
     * Set success value
     * @param \Docdata\StructType\Success $success
     * @return \Docdata\StructType\CreateSuccess
     */
    public function setSuccess(\Docdata\StructType\Success $success = null)
    {
        $this->success = $success;
        return $this;
    }
    /**
     * Get key value
     * @return string
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \Docdata\StructType\CreateSuccess
     */
    public function setKey($key = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($key) && strlen($key) > 32) || (is_array($key) && count($key) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($key) ? strlen($key) : count($key)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($key) && strlen($key) < 32) || (is_array($key) && count($key) < 32)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($key) && !preg_match('/[A-Z,0-9]{32}/', $key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z,0-9]{32}", "%s" given', var_export($key, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get paymentResponse value
     * @return \Docdata\StructType\PaymentResponse|null
     */
    public function getPaymentResponse()
    {
        return $this->paymentResponse;
    }
    /**
     * Set paymentResponse value
     * @param \Docdata\StructType\PaymentResponse $paymentResponse
     * @return \Docdata\StructType\CreateSuccess
     */
    public function setPaymentResponse(\Docdata\StructType\PaymentResponse $paymentResponse = null)
    {
        $this->paymentResponse = $paymentResponse;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Docdata\StructType\CreateSuccess::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Docdata\StructType\CreateSuccess
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Docdata\StructType\CreateSuccess
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
