<?php

namespace Docdata\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Status ServiceType
 * @subpackage Services
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class Status extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named status
     * Meta informations extracted from the WSDL
     * - documentation: Retrieves a report that describes the state of a specified payment order.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Docdata\StructType\StatusRequest $parameters
     * @return \Docdata\StructType\StatusResponse|bool
     */
    public function status(\Docdata\StructType\StatusRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->status($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named statusExtended
     * Meta informations extracted from the WSDL
     * - documentation: Retrieves an extended report that describes the state of a specified payment order.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Docdata\StructType\ExtendedStatusRequest $parameters
     * @return \Docdata\StructType\ExtendedStatusResponse|bool
     */
    public function statusExtended(\Docdata\StructType\ExtendedStatusRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->statusExtended($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Docdata\StructType\ExtendedStatusResponse|\Docdata\StructType\StatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
