<?php

namespace Docdata\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Refund ServiceType
 * @subpackage Services
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class Refund extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named refund
     * Meta informations extracted from the WSDL
     * - documentation: Creates a refund request in the DocData system to (partially) undo a captured amount, so it may be processed later.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Docdata\StructType\RefundRequest $parameters
     * @return \Docdata\StructType\RefundResponse|bool
     */
    public function refund(\Docdata\StructType\RefundRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->refund($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Docdata\StructType\RefundResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
