<?php

namespace Docdata\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Proceed ServiceType
 * @subpackage Services
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class Proceed extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named proceed
     * Meta informations extracted from the WSDL
     * - documentation: Proceeds processing of a payment order in the DocData system. This is a follow-up on the start operation, in case of any required shopper interaction, like 3DS or iDEAL. This operation is called with the result of the shopper
     * interaction and proceeds handling the payment.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Docdata\StructType\ProceedRequest $parameters
     * @return \Docdata\StructType\ProceedResponse|bool
     */
    public function proceed(\Docdata\StructType\ProceedRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->proceed($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Docdata\StructType\ProceedResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
