<?php

namespace Docdata\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel ServiceType
 * @subpackage Services
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named cancel
     * Meta informations extracted from the WSDL
     * - documentation: Cancels an authorized payment order, voiding the order. Only possible if not yet captured, and only for the full amount.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Docdata\StructType\CancelRequest $parameters
     * @return \Docdata\StructType\CancelResponse|bool
     */
    public function cancel(\Docdata\StructType\CancelRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->cancel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Docdata\StructType\CancelResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
