<?php

namespace Docdata\EnumType;

/**
 * This class stands for cancelResult EnumType
 * Meta informations extracted from the WSDL
 * - documentation: The results of the cancel operation. No payments found for this order. All payments in this order were already canceled. All payments in this order are canceled successfully. At least one payment in this order was not canceled
 * successfully. Use the status operation to get more details. A request for cancelation has been sent to the acquirer, but no response received for at least one payment in this order. Use the status operation to get more details.
 * @subpackage Enumerations
 * @Comment This is an automatically generated Docdata PHP SDK
 * @Version 1.3
 * @Date 2017/01/17
 * @Time 13-26
 */
class CancelResult
{
    /**
     * Constant for value 'NO_PAYMENTS'
     * @return string 'NO_PAYMENTS'
     */
    const VALUE_NO_PAYMENTS = 'NO_PAYMENTS';
    /**
     * Constant for value 'ALREADY_CANCELED'
     * @return string 'ALREADY_CANCELED'
     */
    const VALUE_ALREADY_CANCELED = 'ALREADY_CANCELED';
    /**
     * Constant for value 'SUCCESS'
     * @return string 'SUCCESS'
     */
    const VALUE_SUCCESS = 'SUCCESS';
    /**
     * Constant for value 'FAILED'
     * @return string 'FAILED'
     */
    const VALUE_FAILED = 'FAILED';
    /**
     * Constant for value 'PENDING'
     * @return string 'PENDING'
     */
    const VALUE_PENDING = 'PENDING';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NO_PAYMENTS
     * @uses self::VALUE_ALREADY_CANCELED
     * @uses self::VALUE_SUCCESS
     * @uses self::VALUE_FAILED
     * @uses self::VALUE_PENDING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NO_PAYMENTS,
            self::VALUE_ALREADY_CANCELED,
            self::VALUE_SUCCESS,
            self::VALUE_FAILED,
            self::VALUE_PENDING,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
