<?php

namespace Docdata;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'country' => '\\Docdata\\StructType\\Country',
            'language' => '\\Docdata\\StructType\\Language',
            'expiryDate' => '\\Docdata\\StructType\\ExpiryDate',
            'vat' => '\\Docdata\\StructType\\Vat',
            'amount' => '\\Docdata\\StructType\\Amount',
            'menuPreferences' => '\\Docdata\\StructType\\MenuPreferences',
            'css' => '\\Docdata\\StructType\\Css',
            'parameters' => '\\Docdata\\StructType\\Parameters',
            'parameter' => '\\Docdata\\StructType\\Parameter',
            'consideredSafe' => '\\Docdata\\StructType\\ConsideredSafe',
            'name' => '\\Docdata\\StructType\\Name',
            'destination' => '\\Docdata\\StructType\\Destination',
            'technicalIntegrationInfo' => '\\Docdata\\StructType\\TechnicalIntegrationInfo',
            'address' => '\\Docdata\\StructType\\Address',
            'customer' => '\\Docdata\\StructType\\Customer',
            'shopper' => '\\Docdata\\StructType\\Shopper',
            'company' => '\\Docdata\\StructType\\Company',
            'merchant' => '\\Docdata\\StructType\\Merchant',
            'paymentPreferences' => '\\Docdata\\StructType\\PaymentPreferences',
            'exhortation' => '\\Docdata\\StructType\\Exhortation',
            'paymentRequest' => '\\Docdata\\StructType\\PaymentRequest',
            'paymentReference' => '\\Docdata\\StructType\\PaymentReference',
            'threeDomainSecureAuthenticationResult' => '\\Docdata\\StructType\\ThreeDomainSecureAuthenticationResult',
            'iDealAuthorizationResult' => '\\Docdata\\StructType\\IDealAuthorizationResult',
            'refundItems' => '\\Docdata\\StructType\\RefundItems',
            'additionalRefund' => '\\Docdata\\StructType\\AdditionalRefund',
            'itemLine' => '\\Docdata\\StructType\\ItemLine',
            'paymentResponse' => '\\Docdata\\StructType\\PaymentResponse',
            'paymentSuccess' => '\\Docdata\\StructType\\PaymentSuccess',
            'paymentError' => '\\Docdata\\StructType\\PaymentError',
            'invoice' => '\\Docdata\\StructType\\Invoice',
            'totalVatAmount' => '\\Docdata\\StructType\\TotalVatAmount',
            'exhortationPeriod' => '\\Docdata\\StructType\\ExhortationPeriod',
            'error' => '\\Docdata\\StructType\\Error',
            'success' => '\\Docdata\\StructType\\Success',
            'item' => '\\Docdata\\StructType\\Item',
            'quantity' => '\\Docdata\\StructType\\Quantity',
            'paymentRequestInput' => '\\Docdata\\StructType\\PaymentRequestInput',
            'cardPaymentInput' => '\\Docdata\\StructType\\CardPaymentInput',
            'directDebitPaymentInput' => '\\Docdata\\StructType\\DirectDebitPaymentInput',
            'bankTransferPaymentInput' => '\\Docdata\\StructType\\BankTransferPaymentInput',
            'pointOfSalePaymentInput' => '\\Docdata\\StructType\\PointOfSalePaymentInput',
            'offlinePaymentInput' => '\\Docdata\\StructType\\OfflinePaymentInput',
            'elvPaymentInput' => '\\Docdata\\StructType\\ElvPaymentInput',
            'iDealPaymentInput' => '\\Docdata\\StructType\\IDealPaymentInput',
            'statusReport' => '\\Docdata\\StructType\\StatusReport',
            'approximateTotals' => '\\Docdata\\StructType\\ApproximateTotals',
            'payment' => '\\Docdata\\StructType\\Payment',
            'paymentInfo' => '\\Docdata\\StructType\\PaymentInfo',
            'riskCheck' => '\\Docdata\\StructType\\RiskCheck',
            'check' => '\\Docdata\\StructType\\Check',
            'amexPaymentInfo' => '\\Docdata\\StructType\\AmexPaymentInfo',
            'masterCardPaymentInfo' => '\\Docdata\\StructType\\MasterCardPaymentInfo',
            'visaPaymentInfo' => '\\Docdata\\StructType\\VisaPaymentInfo',
            'maestroPaymentInfo' => '\\Docdata\\StructType\\MaestroPaymentInfo',
            'misterCashPaymentInfo' => '\\Docdata\\StructType\\MisterCashPaymentInfo',
            'iDealPaymentInfo' => '\\Docdata\\StructType\\IDealPaymentInfo',
            'sofortPaymentInfo' => '\\Docdata\\StructType\\SofortPaymentInfo',
            'bankTransferPaymentInfo' => '\\Docdata\\StructType\\BankTransferPaymentInfo',
            'giftCardPaymentInfo' => '\\Docdata\\StructType\\GiftCardPaymentInfo',
            'openInvoicePaymentInfo' => '\\Docdata\\StructType\\OpenInvoicePaymentInfo',
            'sepaDirectDebitPaymentInfo' => '\\Docdata\\StructType\\SepaDirectDebitPaymentInfo',
            'elvPaymentInfo' => '\\Docdata\\StructType\\ElvPaymentInfo',
            'pointOfSalePaymentInfo' => '\\Docdata\\StructType\\PointOfSalePaymentInfo',
            'pointOfSalePaymentReceipt' => '\\Docdata\\StructType\\PointOfSalePaymentReceipt',
            'pointOfSalePaymentFormattedReceipt' => '\\Docdata\\StructType\\PointOfSalePaymentFormattedReceipt',
            'pointOfSalePaymentReceiptValues' => '\\Docdata\\StructType\\PointOfSalePaymentReceiptValues',
            'value' => '\\Docdata\\StructType\\Value',
            'systemPaymentInfo' => '\\Docdata\\StructType\\SystemPaymentInfo',
            'shopperBankAccount' => '\\Docdata\\StructType\\ShopperBankAccount',
            'authorization' => '\\Docdata\\StructType\\Authorization',
            'capture' => '\\Docdata\\StructType\\Capture',
            'refund' => '\\Docdata\\StructType\\Refund',
            'chargeback' => '\\Docdata\\StructType\\Chargeback',
            'reversal' => '\\Docdata\\StructType\\Reversal',
            'createRequest' => '\\Docdata\\StructType\\CreateRequest',
            'createResponse' => '\\Docdata\\StructType\\CreateResponse',
            'createSuccess' => '\\Docdata\\StructType\\CreateSuccess',
            'createErrors' => '\\Docdata\\StructType\\CreateErrors',
            'refundRequest' => '\\Docdata\\StructType\\RefundRequest',
            'refundResponse' => '\\Docdata\\StructType\\RefundResponse',
            'refundErrors' => '\\Docdata\\StructType\\RefundErrors',
            'refundSuccess' => '\\Docdata\\StructType\\RefundSuccess',
            'cancelRequest' => '\\Docdata\\StructType\\CancelRequest',
            'cancelResponse' => '\\Docdata\\StructType\\CancelResponse',
            'cancelSuccess' => '\\Docdata\\StructType\\CancelSuccess',
            'cancelErrors' => '\\Docdata\\StructType\\CancelErrors',
            'startRequest' => '\\Docdata\\StructType\\StartRequest',
            'startResponse' => '\\Docdata\\StructType\\StartResponse',
            'startErrors' => '\\Docdata\\StructType\\StartErrors',
            'startSuccess' => '\\Docdata\\StructType\\StartSuccess',
            'proceedRequest' => '\\Docdata\\StructType\\ProceedRequest',
            'proceedResponse' => '\\Docdata\\StructType\\ProceedResponse',
            'proceedErrors' => '\\Docdata\\StructType\\ProceedErrors',
            'proceedSuccess' => '\\Docdata\\StructType\\ProceedSuccess',
            'captureRequest' => '\\Docdata\\StructType\\CaptureRequest',
            'captureResponse' => '\\Docdata\\StructType\\CaptureResponse',
            'captureErrors' => '\\Docdata\\StructType\\CaptureErrors',
            'captureSuccess' => '\\Docdata\\StructType\\CaptureSuccess',
            'statusRequest' => '\\Docdata\\StructType\\StatusRequest',
            'statusResponse' => '\\Docdata\\StructType\\StatusResponse',
            'extendedStatusRequest' => '\\Docdata\\StructType\\ExtendedStatusRequest',
            'extendedStatusResponse' => '\\Docdata\\StructType\\ExtendedStatusResponse',
            'statusErrors' => '\\Docdata\\StructType\\StatusErrors',
            'statusSuccess' => '\\Docdata\\StructType\\StatusSuccess',
            'listPaymentMethodsRequest' => '\\Docdata\\StructType\\ListPaymentMethodsRequest',
            'listPaymentMethodsResponse' => '\\Docdata\\StructType\\ListPaymentMethodsResponse',
            'listPaymentMethodsErrors' => '\\Docdata\\StructType\\ListPaymentMethodsErrors',
            'listPaymentMethodsSuccess' => '\\Docdata\\StructType\\ListPaymentMethodsSuccess',
            'paymentMethod' => '\\Docdata\\StructType\\PaymentMethod',
            'mandateSummary' => '\\Docdata\\StructType\\MandateSummary',
            'sepaBankAccount' => '\\Docdata\\StructType\\SepaBankAccount',
            'salesPerson' => '\\Docdata\\StructType\\SalesPerson',
            'register' => '\\Docdata\\StructType\\Register',
            'offlinePaymentInfo' => '\\Docdata\\StructType\\OfflinePaymentInfo',
            'token' => '\\Docdata\\StructType\\Token',
            'cardTokenInput' => '\\Docdata\\StructType\\CardTokenInput',
            'paymentRedirect' => '\\Docdata\\StructType\\PaymentRedirect',
            'shopperInfo' => '\\Docdata\\StructType\\ShopperInfo',
        );
    }
}
