<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cancelReservationInfo StructType
 * Meta informations extracted from the WSDL
 * - type: tns:cancelReservationInfo
 * @subpackage Structs
 */
class CancelReservationInfo extends AbstractStructBase
{
    /**
     * The authentication
     * @var authentication
     */
    public $authentication;
    /**
     * The reservationNumber
     * @var string
     */
    public $reservationNumber;
    /**
     * The error
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var serviceError[]
     */
    public $error;
    /**
     * Constructor method for cancelReservationInfo
     * @uses CancelReservationInfo::setAuthentication()
     * @uses CancelReservationInfo::setReservationNumber()
     * @uses CancelReservationInfo::setError()
     * @param authentication $authentication
     * @param string $reservationNumber
     * @param serviceError[] $error
     */
    public function __construct(authentication $authentication = null, $reservationNumber = null, array $error = array())
    {
        $this
            ->setAuthentication($authentication)
            ->setReservationNumber($reservationNumber)
            ->setError($error);
    }
    /**
     * Get authentication value
     * @return authentication|null
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param authentication $authentication
     * @return \GreenwayDirectService\StructType\CancelReservationInfo
     */
    public function setAuthentication(authentication $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get reservationNumber value
     * @return string|null
     */
    public function getReservationNumber()
    {
        return $this->reservationNumber;
    }
    /**
     * Set reservationNumber value
     * @param string $reservationNumber
     * @return \GreenwayDirectService\StructType\CancelReservationInfo
     */
    public function setReservationNumber($reservationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($reservationNumber) && !is_string($reservationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reservationNumber)), __LINE__);
        }
        $this->reservationNumber = $reservationNumber;
        return $this;
    }
    /**
     * Get error value
     * @return serviceError[]|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @throws \InvalidArgumentException
     * @param serviceError[] $error
     * @return \GreenwayDirectService\StructType\CancelReservationInfo
     */
    public function setError(array $error = array())
    {
        foreach ($error as $cancelReservationInfoErrorItem) {
            // validation for constraint: itemType
            if (!is_string($cancelReservationInfoErrorItem)) {
                throw new \InvalidArgumentException(sprintf('The error property can only contain items of serviceError, "%s" given', is_object($cancelReservationInfoErrorItem) ? get_class($cancelReservationInfoErrorItem) : gettype($cancelReservationInfoErrorItem)), __LINE__);
            }
        }
        $this->error = $error;
        return $this;
    }
    /**
     * Add item to error value
     * @throws \InvalidArgumentException
     * @param serviceError $item
     * @return \GreenwayDirectService\StructType\CancelReservationInfo
     */
    public function addToError(serviceError $item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The error property can only contain items of serviceError, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->error[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\CancelReservationInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
