<?php

namespace GreenwayDirectService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for whenAndWhereDetails StructType
 * @subpackage Structs
 */
class WhenAndWhereDetails extends AbstractStructBase
{
    /**
     * The date
     * Meta informations extracted from the WSDL
     * - length: 10
     * - pattern: [0-3]{1}[0-9]{1}[/]{1}[0-1]{1}[0-9]{1}[/][0-9]{4}
     * @var string
     */
    public $date;
    /**
     * The time
     * Meta informations extracted from the WSDL
     * - length: 5
     * - pattern: [0-2]{1}[0-9]{1}[:]{1}[0-5]{1}[0-9]{1}
     * @var string
     */
    public $time;
    /**
     * The station
     * Meta informations extracted from the WSDL
     * - length: 6
     * - pattern: [A-Z]{4}[0-9]{2}
     * @var string
     */
    public $station;
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \GreenwayDirectService\RentalAddressType
     */
    public $address;
    /**
     * The deliveryMileage
     * @var string
     */
    public $deliveryMileage;
    /**
     * The collectionMileage
     * @var string
     */
    public $collectionMileage;
    /**
     * The instructions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \GreenwayDirectService\Instructions
     */
    public $instructions;
    /**
     * Constructor method for whenAndWhereDetails
     * @uses WhenAndWhereDetails::setDate()
     * @uses WhenAndWhereDetails::setTime()
     * @uses WhenAndWhereDetails::setStation()
     * @uses WhenAndWhereDetails::setAddress()
     * @uses WhenAndWhereDetails::setDeliveryMileage()
     * @uses WhenAndWhereDetails::setCollectionMileage()
     * @uses WhenAndWhereDetails::setInstructions()
     * @param string $date
     * @param string $time
     * @param string $station
     * @param \GreenwayDirectService\RentalAddressType $address
     * @param string $deliveryMileage
     * @param string $collectionMileage
     * @param \GreenwayDirectService\Instructions $instructions
     */
    public function __construct($date = null, $time = null, $station = null, \GreenwayDirectService\RentalAddressType $address = null, $deliveryMileage = null, $collectionMileage = null, \GreenwayDirectService\Instructions $instructions = null)
    {
        $this
            ->setDate($date)
            ->setTime($time)
            ->setStation($station)
            ->setAddress($address)
            ->setDeliveryMileage($deliveryMileage)
            ->setCollectionMileage($collectionMileage)
            ->setInstructions($instructions);
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \GreenwayDirectService\WhenAndWhereDetails
     */
    public function setDate($date = null)
    {
        // validation for constraint: length
        if ((is_scalar($date) && strlen($date) !== 10) || (is_array($date) && count($date) !== 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($date) && !preg_match('/[0-3]{1}[0-9]{1}[\/]{1}[0-1]{1}[0-9]{1}[\/][0-9]{4}/', $date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-3]{1}[0-9]{1}[/]{1}[0-1]{1}[0-9]{1}[/][0-9]{4}", "%s" given', var_export($date, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get time value
     * @return string|null
     */
    public function getTime()
    {
        return $this->time;
    }
    /**
     * Set time value
     * @param string $time
     * @return \GreenwayDirectService\WhenAndWhereDetails
     */
    public function setTime($time = null)
    {
        // validation for constraint: length
        if ((is_scalar($time) && strlen($time) !== 5) || (is_array($time) && count($time) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($time) && !preg_match('/[0-2]{1}[0-9]{1}[:]{1}[0-5]{1}[0-9]{1}/', $time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-2]{1}[0-9]{1}[:]{1}[0-5]{1}[0-9]{1}", "%s" given', var_export($time, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($time)), __LINE__);
        }
        $this->time = $time;
        return $this;
    }
    /**
     * Get station value
     * @return string|null
     */
    public function getStation()
    {
        return $this->station;
    }
    /**
     * Set station value
     * @param string $station
     * @return \GreenwayDirectService\WhenAndWhereDetails
     */
    public function setStation($station = null)
    {
        // validation for constraint: length
        if ((is_scalar($station) && strlen($station) !== 6) || (is_array($station) && count($station) !== 6)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 6 element(s) or a scalar of 6 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($station) && !preg_match('/[A-Z]{4}[0-9]{2}/', $station)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z]{4}[0-9]{2}", "%s" given', var_export($station, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($station) && !is_string($station)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($station)), __LINE__);
        }
        $this->station = $station;
        return $this;
    }
    /**
     * Get address value
     * @return \GreenwayDirectService\RentalAddressType|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \GreenwayDirectService\RentalAddressType $address
     * @return \GreenwayDirectService\WhenAndWhereDetails
     */
    public function setAddress(\GreenwayDirectService\RentalAddressType $address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Get deliveryMileage value
     * @return string|null
     */
    public function getDeliveryMileage()
    {
        return $this->deliveryMileage;
    }
    /**
     * Set deliveryMileage value
     * @param string $deliveryMileage
     * @return \GreenwayDirectService\WhenAndWhereDetails
     */
    public function setDeliveryMileage($deliveryMileage = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryMileage) && !is_string($deliveryMileage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryMileage)), __LINE__);
        }
        $this->deliveryMileage = $deliveryMileage;
        return $this;
    }
    /**
     * Get collectionMileage value
     * @return string|null
     */
    public function getCollectionMileage()
    {
        return $this->collectionMileage;
    }
    /**
     * Set collectionMileage value
     * @param string $collectionMileage
     * @return \GreenwayDirectService\WhenAndWhereDetails
     */
    public function setCollectionMileage($collectionMileage = null)
    {
        // validation for constraint: string
        if (!is_null($collectionMileage) && !is_string($collectionMileage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($collectionMileage)), __LINE__);
        }
        $this->collectionMileage = $collectionMileage;
        return $this;
    }
    /**
     * Get instructions value
     * @return \GreenwayDirectService\Instructions|null
     */
    public function getInstructions()
    {
        return $this->instructions;
    }
    /**
     * Set instructions value
     * @param \GreenwayDirectService\Instructions $instructions
     * @return \GreenwayDirectService\WhenAndWhereDetails
     */
    public function setInstructions(\GreenwayDirectService\Instructions $instructions = null)
    {
        $this->instructions = $instructions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\WhenAndWhereDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
