<?php

namespace GreenwayDirectService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Amend ServiceType
 * @subpackage Services
 */
class Amend extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named amendOffhire
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GreenwayDirectService\OffhireDetail $parameters
     * @return \GreenwayDirectService\OffhireDetail|bool
     */
    public function amendOffhire(\GreenwayDirectService\OffhireDetail $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->amendOffhire($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named amendReservation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GreenwayDirectService\Reservation $parameters
     * @return \GreenwayDirectService\Reservation|bool
     */
    public function amendReservation(\GreenwayDirectService\Reservation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->amendReservation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named amendRA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GreenwayDirectService\AmendRA $parameters
     * @return \GreenwayDirectService\AmendRA|bool
     */
    public function amendRA(\GreenwayDirectService\AmendRA $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->amendRA($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GreenwayDirectService\AmendRA|\GreenwayDirectService\OffhireDetail|\GreenwayDirectService\Reservation
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
