<?php

namespace GreenwayDirectService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for rentalAddressType StructType
 * @subpackage Structs
 */
class RentalAddressType extends AbstractStructBase
{
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The address1
     * Meta informations extracted from the WSDL
     * - maxLength: 35
     * @var string
     */
    public $address1;
    /**
     * The address2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 35
     * @var string
     */
    public $address2;
    /**
     * The address3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 35
     * @var string
     */
    public $address3;
    /**
     * The address4
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 35
     * @var string
     */
    public $address4;
    /**
     * The city
     * Meta informations extracted from the WSDL
     * - maxLength: 35
     * @var string
     */
    public $city;
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - length: 2
     * @var string
     */
    public $country;
    /**
     * The postCode
     * Meta informations extracted from the WSDL
     * - maxLength: 10
     * @var string
     */
    public $postCode;
    /**
     * The phone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \GreenwayDirectService\PhoneNumberType
     */
    public $phone;
    /**
     * Constructor method for rentalAddressType
     * @uses RentalAddressType::setType()
     * @uses RentalAddressType::setAddress1()
     * @uses RentalAddressType::setAddress2()
     * @uses RentalAddressType::setAddress3()
     * @uses RentalAddressType::setAddress4()
     * @uses RentalAddressType::setCity()
     * @uses RentalAddressType::setCountry()
     * @uses RentalAddressType::setPostCode()
     * @uses RentalAddressType::setPhone()
     * @param string $type
     * @param string $address1
     * @param string $address2
     * @param string $address3
     * @param string $address4
     * @param string $city
     * @param string $country
     * @param string $postCode
     * @param \GreenwayDirectService\PhoneNumberType $phone
     */
    public function __construct($type = null, $address1 = null, $address2 = null, $address3 = null, $address4 = null, $city = null, $country = null, $postCode = null, \GreenwayDirectService\PhoneNumberType $phone = null)
    {
        $this
            ->setType($type)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setAddress3($address3)
            ->setAddress4($address4)
            ->setCity($city)
            ->setCountry($country)
            ->setPostCode($postCode)
            ->setPhone($phone);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \GreenwayDirectService\AddressType::valueIsValid()
     * @uses \GreenwayDirectService\AddressType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \GreenwayDirectService\RentalAddressType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\GreenwayDirectService\AddressType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \GreenwayDirectService\AddressType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->address1;
    }
    /**
     * Set address1 value
     * @param string $address1
     * @return \GreenwayDirectService\RentalAddressType
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($address1) && strlen($address1) > 35) || (is_array($address1) && count($address1) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($address1) ? strlen($address1) : count($address1)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address1)), __LINE__);
        }
        $this->address1 = $address1;
        return $this;
    }
    /**
     * Get address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->address2;
    }
    /**
     * Set address2 value
     * @param string $address2
     * @return \GreenwayDirectService\RentalAddressType
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($address2) && strlen($address2) > 35) || (is_array($address2) && count($address2) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($address2) ? strlen($address2) : count($address2)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address2)), __LINE__);
        }
        $this->address2 = $address2;
        return $this;
    }
    /**
     * Get address3 value
     * @return string|null
     */
    public function getAddress3()
    {
        return $this->address3;
    }
    /**
     * Set address3 value
     * @param string $address3
     * @return \GreenwayDirectService\RentalAddressType
     */
    public function setAddress3($address3 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($address3) && strlen($address3) > 35) || (is_array($address3) && count($address3) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($address3) ? strlen($address3) : count($address3)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($address3) && !is_string($address3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address3)), __LINE__);
        }
        $this->address3 = $address3;
        return $this;
    }
    /**
     * Get address4 value
     * @return string|null
     */
    public function getAddress4()
    {
        return $this->address4;
    }
    /**
     * Set address4 value
     * @param string $address4
     * @return \GreenwayDirectService\RentalAddressType
     */
    public function setAddress4($address4 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($address4) && strlen($address4) > 35) || (is_array($address4) && count($address4) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($address4) ? strlen($address4) : count($address4)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($address4) && !is_string($address4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address4)), __LINE__);
        }
        $this->address4 = $address4;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \GreenwayDirectService\RentalAddressType
     */
    public function setCity($city = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($city) && strlen($city) > 35) || (is_array($city) && count($city) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($city) ? strlen($city) : count($city)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \GreenwayDirectService\RentalAddressType
     */
    public function setCountry($country = null)
    {
        // validation for constraint: length
        if ((is_scalar($country) && strlen($country) !== 2) || (is_array($country) && count($country) !== 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get postCode value
     * @return string|null
     */
    public function getPostCode()
    {
        return $this->postCode;
    }
    /**
     * Set postCode value
     * @param string $postCode
     * @return \GreenwayDirectService\RentalAddressType
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($postCode) && strlen($postCode) > 10) || (is_array($postCode) && count($postCode) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($postCode) ? strlen($postCode) : count($postCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postCode)), __LINE__);
        }
        $this->postCode = $postCode;
        return $this;
    }
    /**
     * Get phone value
     * @return \GreenwayDirectService\PhoneNumberType|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param \GreenwayDirectService\PhoneNumberType $phone
     * @return \GreenwayDirectService\RentalAddressType
     */
    public function setPhone(\GreenwayDirectService\PhoneNumberType $phone = null)
    {
        $this->phone = $phone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\RentalAddressType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
