<?php

namespace GreenwayDirectService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cardDetails StructType
 * @subpackage Structs
 */
class CardDetails extends AbstractStructBase
{
    /**
     * The cardType
     * @var string
     */
    public $cardType;
    /**
     * The cardNumber
     * Meta informations extracted from the WSDL
     * - whiteSpace: collapse
     * @var int
     */
    public $cardNumber;
    /**
     * The expiryDate
     * Meta informations extracted from the WSDL
     * - length: 5
     * - pattern: [0-1]{1}[0-9]{1}[/][0-9]{4}
     * @var string
     */
    public $expiryDate;
    /**
     * The holderName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 35
     * @var string
     */
    public $holderName;
    /**
     * Constructor method for cardDetails
     * @uses CardDetails::setCardType()
     * @uses CardDetails::setCardNumber()
     * @uses CardDetails::setExpiryDate()
     * @uses CardDetails::setHolderName()
     * @param string $cardType
     * @param int $cardNumber
     * @param string $expiryDate
     * @param string $holderName
     */
    public function __construct($cardType = null, $cardNumber = null, $expiryDate = null, $holderName = null)
    {
        $this
            ->setCardType($cardType)
            ->setCardNumber($cardNumber)
            ->setExpiryDate($expiryDate)
            ->setHolderName($holderName);
    }
    /**
     * Get cardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->cardType;
    }
    /**
     * Set cardType value
     * @uses \GreenwayDirectService\CardType::valueIsValid()
     * @uses \GreenwayDirectService\CardType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cardType
     * @return \GreenwayDirectService\CardDetails
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: enumeration
        if (!\GreenwayDirectService\CardType::valueIsValid($cardType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cardType, implode(', ', \GreenwayDirectService\CardType::getValidValues())), __LINE__);
        }
        $this->cardType = $cardType;
        return $this;
    }
    /**
     * Get cardNumber value
     * @return int|null
     */
    public function getCardNumber()
    {
        return $this->cardNumber;
    }
    /**
     * Set cardNumber value
     * @param int $cardNumber
     * @return \GreenwayDirectService\CardDetails
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: int
        if (!is_null($cardNumber) && !is_numeric($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cardNumber)), __LINE__);
        }
        $this->cardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get expiryDate value
     * @return string|null
     */
    public function getExpiryDate()
    {
        return $this->expiryDate;
    }
    /**
     * Set expiryDate value
     * @param string $expiryDate
     * @return \GreenwayDirectService\CardDetails
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: length
        if ((is_scalar($expiryDate) && strlen($expiryDate) !== 5) || (is_array($expiryDate) && count($expiryDate) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($expiryDate) && !preg_match('/[0-1]{1}[0-9]{1}[\/][0-9]{4}/', $expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-1]{1}[0-9]{1}[/][0-9]{4}", "%s" given', var_export($expiryDate, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expiryDate)), __LINE__);
        }
        $this->expiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get holderName value
     * @return string|null
     */
    public function getHolderName()
    {
        return $this->holderName;
    }
    /**
     * Set holderName value
     * @param string $holderName
     * @return \GreenwayDirectService\CardDetails
     */
    public function setHolderName($holderName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($holderName) && strlen($holderName) > 35) || (is_array($holderName) && count($holderName) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($holderName) ? strlen($holderName) : count($holderName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($holderName) && !is_string($holderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($holderName)), __LINE__);
        }
        $this->holderName = $holderName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\CardDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
