<?php

namespace GreenwayDirectService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cancelResDetail StructType
 * @subpackage Structs
 */
class CancelResDetail extends AbstractStructBase
{
    /**
     * The authentication
     * @var \GreenwayDirectService\AuthenticationType
     */
    public $authentication;
    /**
     * The reservationNumber
     * @var int
     */
    public $reservationNumber;
    /**
     * The error
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GreenwayDirectService\ErrorType[]
     */
    public $error;
    /**
     * Constructor method for cancelResDetail
     * @uses CancelResDetail::setAuthentication()
     * @uses CancelResDetail::setReservationNumber()
     * @uses CancelResDetail::setError()
     * @param \GreenwayDirectService\AuthenticationType $authentication
     * @param int $reservationNumber
     * @param \GreenwayDirectService\ErrorType[] $error
     */
    public function __construct(\GreenwayDirectService\AuthenticationType $authentication = null, $reservationNumber = null, array $error = array())
    {
        $this
            ->setAuthentication($authentication)
            ->setReservationNumber($reservationNumber)
            ->setError($error);
    }
    /**
     * Get authentication value
     * @return \GreenwayDirectService\AuthenticationType|null
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param \GreenwayDirectService\AuthenticationType $authentication
     * @return \GreenwayDirectService\CancelResDetail
     */
    public function setAuthentication(\GreenwayDirectService\AuthenticationType $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get reservationNumber value
     * @return int|null
     */
    public function getReservationNumber()
    {
        return $this->reservationNumber;
    }
    /**
     * Set reservationNumber value
     * @param int $reservationNumber
     * @return \GreenwayDirectService\CancelResDetail
     */
    public function setReservationNumber($reservationNumber = null)
    {
        // validation for constraint: int
        if (!is_null($reservationNumber) && !is_numeric($reservationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reservationNumber)), __LINE__);
        }
        $this->reservationNumber = $reservationNumber;
        return $this;
    }
    /**
     * Get error value
     * @return \GreenwayDirectService\ErrorType[]|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\ErrorType[] $error
     * @return \GreenwayDirectService\CancelResDetail
     */
    public function setError(array $error = array())
    {
        foreach ($error as $cancelResDetailErrorItem) {
            // validation for constraint: itemType
            if (!$cancelResDetailErrorItem instanceof \GreenwayDirectService\ErrorType) {
                throw new \InvalidArgumentException(sprintf('The error property can only contain items of \GreenwayDirectService\ErrorType, "%s" given', is_object($cancelResDetailErrorItem) ? get_class($cancelResDetailErrorItem) : gettype($cancelResDetailErrorItem)), __LINE__);
            }
        }
        $this->error = $error;
        return $this;
    }
    /**
     * Add item to error value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\ErrorType $item
     * @return \GreenwayDirectService\CancelResDetail
     */
    public function addToError(\GreenwayDirectService\ErrorType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayDirectService\ErrorType) {
            throw new \InvalidArgumentException(sprintf('The error property can only contain items of \GreenwayDirectService\ErrorType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->error[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\CancelResDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
